
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Data for the bar charts
civil_war_recall = np.array(
    [
        [75.3, 68.9, 59.8],
        [55.3, 51.7, 46.6],
        [50.0, 47.6, 41.5],
        [45.8, 42.2, 35.6],
        [30.3, 28.9, 25.5],
    ]
)
world_war_ii_recall = np.array(
    [
        [20.1, 23.6, 21.7],
        [40.3, 45.0, 35.5],
        [45.5, 50.6, 40.5],
        [55.5, 60.8, 50.8],
        [70.7, 65.6, 55.4],
    ]
)
x = [0, 1, 2]

# Titles for subplots
titles = [
    "Group A: Year 1",
    "Group A: Year 2",
    "Group B: Year 1",
    "Group B: Year 2",
    "Group C: Year 1",
]

labels = ["Civil War Recall", "World War II Recall"]
ylim = [-80, 80]
xticks = [0, 1, 2]
xticklabels = ["Test 1", "Test 2", "Test 3"]

# Axis labels and supertitle
xlabel = "Test"
ylabel = "Recall Rate (%)"
suptitle = "Recall Rates of Historical Events by Student Groups"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size to match the original image's dimensions
plt.figure(figsize=(14, 4))

# Create subplots
for i in range(5):
    ax = plt.subplot(1, 5, i + 1)
    ax.bar(x, civil_war_recall[i], width=0.5, label=labels[0], color="#8b4513")
    ax.bar(x, -world_war_ii_recall[i], width=0.5, label=labels[1], color="#4682b4")
    ax.set_title(titles[i], fontsize=10, fontweight='bold')
    ax.set_ylim(ylim)
    ax.set_xticks(xticks)
    ax.set_xticklabels(xticklabels)
    ax.set_xlabel(xlabel)
    ax.set_ylabel(ylabel)
    ax.yaxis.grid(True, linestyle="--")
    ax.set_axisbelow(True)

    # Annotate bars with their values
    for j in range(3):
        ax.text(
            x[j], civil_war_recall[i][j] - 7, str(civil_war_recall[i][j]), ha="center"
        )
        ax.text(
            x[j],
            -world_war_ii_recall[i][j] + 5,
            str(world_war_ii_recall[i][j]),
            ha="center",
        )

# Add legend to the first subplot
plt.subplot(1, 5, 1).legend(loc="lower right", frameon=False)

# Add supertitle
plt.suptitle(suptitle, fontsize=14, fontweight='bold')

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout(rect=[0, 0, 1, 0.95])
plt.savefig("bar_202.pdf", bbox_inches="tight")
