
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data for the bar charts
gdp_growth = np.array(
    [
        [3.2, 2.9, 2.5],
        [1.5, 1.8, 1.9],
        [0.7, 1.1, 1.3],
        [0.2, 0.4, 0.5],
        [-0.5, -0.3, 0.0],
    ]
)
unemployment_rate = np.array(
    [
        [5.1, 5.3, 5.2],
        [6.8, 6.6, 6.5],
        [7.5, 7.3, 7.1],
        [8.0, 7.9, 7.8],
        [9.0, 8.8, 8.7],
    ]
)
x = [0, 1, 2]

# Titles for subplots
titles = [
    "Scenario 1: Boom",
    "Scenario 2: Moderate Growth",
    "Scenario 3: Slow Growth",
    "Scenario 4: Stagnation",
    "Scenario 5: Recession",
]

ylabel = "Percentage (%)"
xlabel = "Year"
legendlabels = ["GDP Growth", "Unemployment Rate"]
ylim = [-10, 10]
xticks = [0, 1, 2]
xticklabels = ["2020", "2021", "2022"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size
fig, axs = plt.subplots(1, 5, figsize=(17, 4))

for i in range(5):
    ax = axs[i]
    ax.bar(x, gdp_growth[i], width=0.35, label=legendlabels[0], color="#4c72b0")
    ax.bar(x, -unemployment_rate[i], width=0.35, label=legendlabels[1], color="#c44e52")
    ax.set_title(titles[i])
    ax.set_ylim(ylim)
    ax.set_xticks(xticks)
    ax.set_xticklabels(xticklabels)
    ax.set_ylabel(ylabel)
    ax.set_xlabel(xlabel)
    ax.yaxis.grid(True, linestyle="--")
    ax.set_axisbelow(True)

    # Annotate bars with their values
    for j in range(3):
        ax.text(
            x[j], gdp_growth[i][j] - 0.7, f'{gdp_growth[i][j]:.1f}', ha="center", color='blue'
        )
        ax.text(
            x[j],
            -unemployment_rate[i][j] + 0.5,
            f'{unemployment_rate[i][j]:.1f}',
            ha="center",
            color='red'
        )

# Add legend to the first subplot
axs[0].legend(loc="upper left", frameon=False)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.suptitle('Economic Scenarios: GDP Growth vs. Unemployment Rate', y=1.02, fontsize=16)
plt.savefig("bar_203.pdf", bbox_inches="tight")
