
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data
tasks = [
    "Analytic Philosophy",
    "Ethics",
    "Metaphysics",
    "Epistemology",
    "Logic",
    "Aesthetics",
    "Political Philosophy",
    "Philosophy of Mind",
    "Philosophy of Science",
    "Phenomenology",
    "Existentialism",
    "Critical Theory",
    "Hermeneutics",
    "Nihilism",
    "Idealism",
    "Pragmatism",
    "Stoicism",
    "Hedonism",
    "Constructivism",
    "Rationalism",
    "Empiricism",
    "Structuralism",
    "Post-Structuralism",
    "Utilitarianism",
    "Deontology",
    "Virtue Ethics",
    "Naturalism",
    "Transcendentalism"
]
delta_accuracy = np.random.uniform(-8, 5, len(tasks))

# Styling variables
xlim_values = (-1, len(tasks))
ylim_values = (-8, 6)
xlabel_text = "Philosophical Tasks"
ylabel_text = "ΔAcc (With Model) - Acc (Without Model)"
title_text = "Model = Philosophy AI"
legend_labels = ["ΔAcc < -1", "-1 <= ΔAcc <= 1", "ΔAcc > 1"]
yticks_values = [-8, -6, -4, -2, 0, 2, 4, 6]



# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plot
fig, ax = plt.subplots(figsize=(10, 6))
# Colors based on delta accuracy
colors = [
    "#1f77b4" if x < 0 else "#ff7f0e" if 0 <= x <= 1 else "#2ca02c"
    for x in delta_accuracy
]
bars = ax.bar(tasks, delta_accuracy, color=colors)

# Labels and Title
ax.set_xlim(*xlim_values)
ax.set_xticks([])
ax.set_ylim(*ylim_values)
ax.set_yticks(yticks_values)
ax.set_xlabel(xlabel_text)
ax.set_ylabel(ylabel_text)
ax.set_title(title_text)

# Add text labels
for bar, task in zip(bars, tasks):
    y = bar.get_height()
    rotation = 90
    if y < 0:
        ax.text(
            bar.get_x() + bar.get_width() / 2,
            0.2,
            task,
            rotation=rotation,
            ha="center",
            va="bottom",
            fontsize=8
        )
    else:
        ax.text(
            bar.get_x() + bar.get_width() / 2,
            -0.2,
            task,
            rotation=rotation,
            ha="center",
            va="top",
            fontsize=8
        )

# Legend
blue_patch = plt.Rectangle((0, 0), 1, 1, fc="#1f77b4", edgecolor="none")
orange_patch = plt.Rectangle((0, 0), 1, 1, fc="#ff7f0e", edgecolor="none")
green_patch = plt.Rectangle((0, 0), 1, 1, fc="#2ca02c", edgecolor="none")
ax.legend(
    [blue_patch, orange_patch, green_patch],
    legend_labels,
    loc="lower center",
    bbox_to_anchor=(0.5, -0.15),
    ncol=3,
    frameon=False,
)

plt.tick_params(axis="both", which="both", length=0)
ax.grid(axis='y', linestyle='--', alpha=0.7)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout
plt.tight_layout()
plt.savefig("bar_206.pdf", bbox_inches="tight")
