
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Historical periods data
categories = [
    "Renaissance",
    "Age of Discovery",
    "Industrial Revolution",
    "American Revolution",
    "French Revolution",
    "World War I",
    "World War II",
    "Cold War",
    "Digital Age",
]
impact_scores = np.random.randint(5, 30, size=len(categories))
significance_scores = np.random.randint(5, 20, size=len(categories))

# Positions of the bars on the x-axis
r = np.arange(len(categories))

# Labels and text
labels = ["Impact Score", "Significance Score"]
xlabel = "Historical Periods"
ylabel = "Scores"
title = "Impact and Significance of Historical Periods"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Bar width
bar_width = 0.6

# Color palette
impact_color = "#8b0000"          # Dark Red (Burgundy)
significance_color = "#4682b4"    # Steel Blue (Teal)

# Create the figure and the axes
fig, ax = plt.subplots(figsize=(10, 6))

# Plot the bars
ax.bar(
    r,
    impact_scores,
    bottom=significance_scores,
    color=impact_color,
    width=bar_width,
    label=labels[0],
)
ax.bar(r, significance_scores, color=significance_color, width=bar_width, label=labels[1])

# Add labels, title, and legend
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)
ax.set_xticks(r)
ax.set_xticklabels(categories, rotation=45, ha="right")
ax.legend(loc="upper left")

# Additional style adjustments
ax.grid(axis='y', linestyle='--', alpha=0.7)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout
plt.tight_layout()
plt.savefig("bar_210.pdf", bbox_inches="tight")
