
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# New dataset relevant to societal categories
categories = [
    "Education",
    "Healthcare",
    "Employment",
    "Housing",
    "Public Safety",
    "Environment",
    "Transportation",
    "Income",
    "Technology",
    "Civic Engagement",
    "Equality",
    "Community Services",
    "Recreation",
    "Culture",
    "Nutrition",
    "Mental Health",
    "Family Support",
    "Public Policy",
    "Immigration",
    "Crime",
]
metric_1_values = np.random.randint(50, 200, size=len(categories))
metric_2_values = np.random.randint(30, 100, size=len(categories))

# Positions of the bars on the x-axis
r = np.arange(len(categories))

labels = ["Metric 1: Public Satisfaction", "Metric 2: Government Spending"]
xlabel = "Societal Categories"
ylabel = "Values"
title = "Comparison of Public Satisfaction and Government Spending in Various Societal Categories"
suptitle = "Society Metrics Analysis"
legend_location = "upper right"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Bar width
bar_width = 0.6

# Create the figure and the axes
fig, ax = plt.subplots(figsize=(10, 8))

# Plot the bars
ax.bar(
    r,
    metric_1_values,
    bottom=metric_2_values,
    color="#69b3a2",
    width=bar_width,
    label=labels[0],
)
ax.bar(r, metric_2_values, color="#8e44ad", width=bar_width, label=labels[1])

# Add labels, titles, and legends
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_xticks(r)
ax.set_xticklabels(categories, rotation=45, ha="right")
ax.set_title(title) 
fig.suptitle(suptitle, fontsize=14, fontweight='bold')
ax.legend(loc=legend_location)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout
plt.tight_layout()
plt.savefig("bar_212.pdf", bbox_inches="tight")
