
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data
books = ["Book A", "Book B", "Book C", "Book D"]
Character_X = [120, 150, 200, 230]
Character_Y = [100, 130, 170, 210]
Character_Z = [90, 140, 160, 220]
Character_W = [80, 120, 150, 200]

# X-axis positions for each group
x = np.arange(len(books))

# Labels and Titles
ylabel = "Word Count"
xlabel = "Books"
title = "Word Counts of Characters in Books"

# Legend labels
legend_labels = ["Character X", "Character Y", "Character Z", "Character W"]

# Axis limits
ylim = (0, 250)

# Axis tick labels
xticks = x
xticklabels = books

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Bar width
bar_width = 0.2

# Colors - A new color palette
colors = ["#6b5b95", "#feb236", "#d64161", "#ff7b25"]

# Figure and axis
fig, ax = plt.subplots(figsize=(10, 7))

# Plotting bars
ax.bar(
    x - bar_width * 1.5,
    Character_X,
    width=bar_width,
    label=legend_labels[0],
    color=colors[0],
)
ax.bar(
    x - bar_width / 2,
    Character_Y,
    width=bar_width,
    label=legend_labels[1],
    color=colors[1],
)
ax.bar(
    x + bar_width / 2,
    Character_Z,
    width=bar_width,
    label=legend_labels[2],
    color=colors[2],
)
ax.bar(
    x + bar_width * 1.5,
    Character_W,
    width=bar_width,
    label=legend_labels[3],
    color=colors[3],
)

# Adding labels and title
ax.set_ylim(ylim)
ax.set_ylabel(ylabel, fontsize=12, fontweight='bold')
ax.set_xlabel(xlabel, fontsize=12, fontweight='bold')
ax.set_title(title, fontsize=14, fontweight='bold')

# Adding x-axis tick labels
ax.set_xticks(xticks)
ax.set_xticklabels(xticklabels, fontsize=10)

plt.tick_params(axis="both", which="both", length=0)

# Adding legend
ax.legend(loc="lower center", bbox_to_anchor=(0.5, -0.15), frameon=False, ncol=4)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_213.pdf", bbox_inches="tight")

