
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data
audience_sizes = [1, 2, 3, 4]
Email = [75, 80, 65, 70]
Video_Call = [65, 70, 75, 80]
In_Person = [85, 90, 80, 85]
Social_Media = [60, 65, 70, 75]

# X-axis positions for each group
x = np.arange(len(audience_sizes))

# Labels and Titles
ylabel = "Effectiveness Score"
xlabel = "Audience Size"
title = "Effectiveness of Communication Methods"

# Legend labels
legend_labels = ["Email", "Video Call", "In-Person", "Social Media"]

# Axis limits
ylim = (0, 100)

# Axis tick labels
xticks = x
xticklabels = ["Small", "Medium", "Large", "Very Large"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Bar width
bar_width = 0.2

# Colors
colors = ["#4E79A7", "#F28E2C", "#E15759", "#76B7B2"]

# Figure and axis
fig, ax = plt.subplots(figsize=(10, 7))

# Plotting bars
ax.bar(
    x - bar_width * 1.5,
    Email,
    width=bar_width,
    label=legend_labels[0],
    color=colors[0],
)
ax.bar(
    x - bar_width / 2,
    Video_Call,
    width=bar_width,
    label=legend_labels[1],
    color=colors[1],
)
ax.bar(
    x + bar_width / 2,
    In_Person,
    width=bar_width,
    label=legend_labels[2],
    color=colors[2],
)
ax.bar(
    x + bar_width * 1.5,
    Social_Media,
    width=bar_width,
    label=legend_labels[3],
    color=colors[3],
)

# Adding labels and title
ax.set_ylim(ylim)
ax.set_ylabel(ylabel)
ax.set_xlabel(xlabel)
ax.set_title(title)

# Adding x-axis tick labels
ax.set_xticks(xticks)
ax.set_xticklabels(xticklabels)

plt.tick_params(axis="both", which="both", length=0)
ax.grid(axis='y', linestyle='--', alpha=0.7)

# Adding legend
ax.legend(loc="lower center", bbox_to_anchor=(0.5, -0.15), frameon=False, ncol=4)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_214.pdf", bbox_inches="tight")
