
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data
sunlight_exposure = ["Low", "Medium", "High", "Very High"]
Fertilizer_A = [2, 4, 5, 7]
Fertilizer_B = [3, 5, 6, 8]
Fertilizer_C = [1, 3, 4, 6]
Fertilizer_D = [2.5, 4.5, 5.5, 7.5]

# X-axis positions for each group
x = np.arange(len(sunlight_exposure))

# Labels and Titles
ylabel = "Effectiveness Score"
xlabel = "Sunlight Exposure"
title = "Effectiveness of Fertilizers Under Different Sunlight Conditions"

# Legend labels
legend_labels = ["Fertilizer A", "Fertilizer B", "Fertilizer C", "Fertilizer D"]

# Axis limits
ylim = (0, 9)

# Axis tick labels
xticks = x
xticklabels = sunlight_exposure

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Bar width
bar_width = 0.2

# Colors
colors = ["#99d98c", "#76c893", "#52b69a", "#34a0a4"]

# Figure and axis
fig, ax = plt.subplots(figsize=(10, 7))

# Plotting bars
ax.bar(
    x - bar_width * 1.5,
    Fertilizer_A,
    width=bar_width,
    label=legend_labels[0],
    color=colors[0],
)
ax.bar(
    x - bar_width / 2,
    Fertilizer_B,
    width=bar_width,
    label=legend_labels[1],
    color=colors[1],
)
ax.bar(
    x + bar_width / 2,
    Fertilizer_C,
    width=bar_width,
    label=legend_labels[2],
    color=colors[2],
)
ax.bar(
    x + bar_width * 1.5,
    Fertilizer_D,
    width=bar_width,
    label=legend_labels[3],
    color=colors[3],
)

# Adding labels and title
ax.set_ylim(ylim)
ax.set_ylabel(ylabel)
ax.set_xlabel(xlabel)
ax.set_title(title)

# Adding x-axis tick labels
ax.set_xticks(xticks)
ax.set_xticklabels(xticklabels)

# Removing tick marks for cleaner look
plt.tick_params(axis="both", which="both", length=0)

# Adding legend
ax.legend(loc="lower center", bbox_to_anchor=(0.5, -0.15), frameon=False, ncol=4)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_215.pdf", bbox_inches="tight")
