
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data for the bar charts
categories = ["New York", "Los Angeles", "Chicago", "Houston"]
sunny = [60, 70, 50, 80]
cloudy = [20, 15, 30, 10]
rainy = [20, 15, 20, 10]

labels = ["Sunny", "Cloudy", "Rainy"]
titles = [
    "Weather Stats for New York",
    "Weather Stats for Los Angeles",
    "Weather Stats for Chicago",
    "Weather Stats for Houston",
]
xlabel = "Percentage of Days"
ylabel = "City"
legendlabels = labels

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with custom size
fig, axes = plt.subplots(2, 2, figsize=(13, 6))

# Function to create a bar chart
def create_bar_chart(ax, sunny, cloudy, rainy, title):
    bar_width = 0.5
    indices = np.arange(len(categories))

    ax.barh(indices, sunny, bar_width, color="#f1c40f", label=labels[0])
    ax.barh(indices, cloudy, bar_width, left=sunny, color="#95a5a6", label=labels[1])
    ax.barh(indices, rainy, bar_width, left=np.add(sunny, cloudy), color="#3498db", label=labels[2])

    ax.set_yticks(indices)
    ax.set_yticklabels(categories)
    ax.invert_yaxis()  # labels read top-to-bottom
    ax.set_title(title)
    ax.set_xlim(0, 100)
    ax.set_xlabel(xlabel)
    ax.set_ylabel(ylabel)
    ax.grid(True, which="both", linestyle='--', linewidth=0.5)

    for i, (s, c, r) in enumerate(zip(sunny, cloudy, rainy)):
        ax.text(s / 2, i, f"{s}%", ha="center", va="center", color="black")
        ax.text(s + c / 2, i, f"{c}%", ha="center", va="center", color="black")
        ax.text(s + c + r / 2, i, f"{r}%", ha="center", va="center", color="black")

    for spine in ax.spines.values():
        spine.set_visible(False)
    ax.set_yticklabels(categories, rotation=0)

# Create each bar chart
create_bar_chart(axes[0, 0], sunny, cloudy, rainy, titles[0])
create_bar_chart(axes[1, 0], sunny, cloudy, rainy, titles[1])
create_bar_chart(axes[0, 1], sunny, cloudy, rainy, titles[2])
create_bar_chart(axes[1, 1], sunny, cloudy, rainy, titles[3])

# Add a legend
handles, labels = axes[0, 0].get_legend_handles_labels()
fig.legend(handles, labels, loc="lower center", ncol=3)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout(rect=[0, 0.05, 1, 1])
plt.savefig("bar_220.pdf", bbox_inches="tight")

