
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data
algorithms = ["Alg1", "Alg2", "Alg3", "Alg4"]
travel_time = [30, 25, 20, 22]
fuel_efficiency = [5.5, 5.0, 4.5, 4.8]

labels = ["Travel Time (mins)", "Fuel Efficiency (L/100km)"]

# X-axis positions
x = np.arange(len(algorithms))
indexs = [2, 4]

# Plot labels
title_transit = "(a) Public Transit"
title_rideshare = "(b) Rideshare"
ylabel_transit = "Time (mins)"
ylabel_rideshare = "Fuel (L/100km)"
yticks_transit = np.arange(0, 40, 5)
yticks_rideshare = np.arange(0, 8, 1)

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create subplots
colors = ["#1f77b4", "#ff7f0e", "#2ca02c", "#17becf"]
fig, (ax1, ax2) = plt.subplots(2, 1, figsize=(5, 6))

barwidth = 0.3
# Transit subplot
for i in range(len(x)):
    ax1.bar(
        (i - 2) * 0.3 + indexs[0],
        travel_time[i],
        width=0.3,
        label="Travel Time",
        color=colors[i],
    )
    ax1.bar(
        (i - 2) * 0.3 + indexs[1],
        fuel_efficiency[i],
        width=0.3,
        label="Fuel Efficiency",
        color=colors[i],
    )
ax1.set_title(title_transit)
ax1.set_xticks([index - 0.15 for index in indexs])
ax1.set_xticklabels(labels)
ax1.set_ylabel(ylabel_transit)
ax1.set_yticks(yticks_transit)
ax1.tick_params(axis="both", which="both", length=0)

# Rideshare subplot
for i in range(len(x)):
    ax2.bar(
        (i - 2) * 0.3 + indexs[0],
        travel_time[i] + 3,  # Assume rideshare is slightly slower on average
        width=0.3,
        label="Travel Time",
        color=colors[i],
    )
    ax2.bar(
        (i - 2) * 0.3 + indexs[1],
        fuel_efficiency[i] - 0.3,  # Assume rideshare is slightly more efficient on average
        width=0.3,
        label="Fuel Efficiency",
        color=colors[i],
    )
ax2.set_title(title_rideshare)
ax2.set_xticks([index - 0.15 for index in indexs])
ax2.set_xticklabels(labels)
ax2.set_ylabel(ylabel_rideshare)
ax2.set_yticks(yticks_rideshare)

ax2.tick_params(axis="both", which="both", length=0)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("bar_222.pdf", bbox_inches="tight")
