
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data
decades = ["1990", "2000", "2010", "2020"]
carbon_emissions = [30.5, 29.8, 28.0, 27.5]
renewable_energy = [12.1, 14.3, 18.5, 22.2]
carbon_emissions_scenario_b = [30.0, 29.0, 27.0, 26.0]
renewable_energy_scenario_b = [12.0, 14.0, 18.0, 22.0]

labels = ["Carbon Emissions", "Renewable Energy"]

# X-axis positions
x = np.arange(len(decades))
indexs = [2, 4]

# Plot labels
scenario_a_title = "(a) Scenario A"
scenario_b_title = "(b) Scenario B"
ylabel_carbon = "Carbon Emissions (in gigatonnes)"
ylabel_renewable = "Renewable Energy Usage (%)"
yticks_carbon = [20, 22, 24, 26, 28, 30, 32]
yticks_renewable = [10, 12, 14, 16, 18, 20, 22, 24]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create subplots
colors = ["#2ca02c", "#1f77b4", "#ff7f0e", "#9467bd"]
fig, (ax1, ax2) = plt.subplots(2, 1, figsize=(7, 8))

barwidth = 0.3
# Scenario A subplot
for i in range(len(x)):
    ax1.bar(
        (i - 2) * 0.3 + indexs[0],
        carbon_emissions[i],
        width=barwidth,
        label="Carbon Emissions" if i == 0 else "",
        color=colors[i],
    )
    ax1.bar(
        (i - 2) * 0.3 + indexs[1],
        renewable_energy[i],
        width=barwidth,
        label="Renewable Energy" if i == 0 else "",
        color=colors[i],
        hatch="/",
    )
ax1.set_title(scenario_a_title)
ax1.set_xticks([index - 0.15 for index in indexs])
ax1.set_xticklabels(labels)
ax1.set_ylabel(ylabel_carbon)
ax1.set_yticks(yticks_carbon)
ax1.tick_params(axis="both", which="both", length=0)
ax1.legend()

# Scenario B subplot
for i in range(len(x)):
    ax2.bar(
        (i - 2) * 0.3 + indexs[0],
        carbon_emissions_scenario_b[i],
        width=barwidth,
        label="Carbon Emissions" if i == 0 else "",
        color=colors[i],
    )
    ax2.bar(
        (i - 2) * 0.3 + indexs[1],
        renewable_energy_scenario_b[i],
        width=barwidth,
        label="Renewable Energy" if i == 0 else "",
        color=colors[i],
        hatch="/",
    )
ax2.set_title(scenario_b_title)
ax2.set_xticks([index - 0.15 for index in indexs])
ax2.set_xticklabels(labels)
ax2.set_ylabel(ylabel_renewable)
ax2.set_yticks(yticks_renewable)
ax2.tick_params(axis="both", which="both", length=0)
ax2.legend()

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("bar_223.pdf", bbox_inches="tight")
