

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data
subjects = ["Math", "Science", "English", "History"]
easy = [88, 85, 90, 78]
medium = [75, 70, 80, 65]
hard = [65, 60, 70, 55]
very_hard = [55, 50, 60, 45]

labels = ["Easy", "Medium", "Hard", "Very Hard"]
xlabel = "Subjects"
ylabel = "Performance Scores (%)"
title = "Student Performance by Subject and Difficulty Level"
yaxhline = 90
ylim = [0, 100]
yticks = np.arange(0, 110, 20)

# Positions of bars on x-axis
ind = np.arange(len(subjects))

# Text for annotations
texts = ["-13%", "-15%", "-10%", "-15%"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Bar width
bar_width = 0.2

# Figure size
plt.figure(figsize=(10, 7))

# Plotting
plt.bar(ind, easy, width=bar_width, label=labels[0], color="#7fc97f")
plt.bar(
    ind + bar_width,
    medium,
    width=bar_width,
    label=labels[1],
    color="#beaed4",
    hatch="//",
)
plt.bar(ind + bar_width * 2, hard, width=bar_width, label=labels[2], color="#fdc086")
plt.bar(
    ind + bar_width * 3,
    very_hard,
    width=bar_width,
    label=labels[3],
    color="#ffff99",
    hatch="/",
)

# Highlighting the most significant changes
distance = 0.05
plt.annotate(
    "",
    xy=(ind[0] + bar_width, 75),
    xytext=(ind[0] + bar_width, 90),
    arrowprops=dict(facecolor="black", shrink=0.02),
)
plt.text(ind[0] + bar_width + distance, 80, texts[0])
plt.annotate(
    "",
    xy=(ind[1] + bar_width, 70),
    xytext=(ind[1] + bar_width, 90),
    arrowprops=dict(facecolor="black", shrink=0.02),
    va="center",
)
plt.text(ind[1] + bar_width + distance, 78, texts[1])
plt.annotate(
    "",
    xy=(ind[2] + bar_width * 2, 70),
    xytext=(ind[2] + bar_width * 2, 90),
    arrowprops=dict(facecolor="black", shrink=0.02),
)
plt.text(ind[2] + bar_width * 2 + distance, 80, texts[2])
plt.annotate(
    "",
    xy=(ind[3] + bar_width * 3, 50),
    xytext=(ind[3] + bar_width * 3, 90),
    arrowprops=dict(facecolor="red", shrink=0.02),
    ha="center",
)
plt.text(ind[3] + bar_width * 3 + distance, 68, texts[3])

# Adding horizontal line
plt.axhline(y=yaxhline, color="blue", linestyle="--", linewidth=2)

# X-axis labels
plt.xticks(ind + bar_width * 1.5, subjects)

# Y-axis labels
plt.ylim(ylim)
plt.yticks(yticks)

# Legend
plt.legend(loc="upper center", bbox_to_anchor=(0.5, 1.15), ncol=2)

# Grid lines
plt.grid(axis="y")

# Labels and Title
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_226.pdf", bbox_inches="tight")

