
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)

# Data
months = ["January", "February", "March", "April"]
new_york = [3.1, 2.8, 3.9, 4.1]
los_angeles = [3.4, 3.7, 2.9, 0.8]
chicago = [1.8, 1.5, 2.2, 3.7]
houston = [3.5, 2.9, 3.3, 4.5]

labels = ["New York", "Los Angeles", "Chicago", "Houston"]
xlabel = "Months"
ylabel = "Average Rainfall (inches)"
title = "Average Monthly Rainfall in Different Cities"
yaxhline = 4.0
ylim = [0, 9]
yticks = np.arange(0, 10, 1)

# Positions of bars on x-axis
ind = np.arange(len(months))

texts = ["1.2", "0.8", "1.0", "0.1"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Bar width
bar_width = 0.2

# Figure size
plt.figure(figsize=(10, 7))

# Plotting
plt.bar(ind, new_york, width=bar_width, label=labels[0], color="#1f77b4")
plt.bar(
    ind,
    los_angeles,
    width=bar_width,
    label=labels[1],
    color="#aec7e8",
    hatch="//",
    bottom=new_york,
)
plt.bar(ind + bar_width, chicago, width=bar_width, label=labels[2], color="#ff7f0e")
plt.bar(
    ind + bar_width,
    houston,
    width=bar_width,
    label=labels[3],
    color="#ffbb78",
    hatch="/",
    bottom=chicago,
)

# Highlighting the most significant deviation
distance = 0.05
plt.annotate(
    "",
    xy=(ind[0] + bar_width, 4),
    xytext=(ind[0] + bar_width,1.8),
    arrowprops=dict(facecolor="black", shrink=0.02),
)
plt.text(ind[0] + bar_width + distance, 2.65, texts[0])
plt.annotate(
    "",
    xy=(ind[1], 4),
    xytext=(ind[1], 2.9),
    arrowprops=dict(facecolor="black", shrink=0.02),
    va="center",
)
plt.text(ind[1] - distance * 6, 3.5, texts[1])
plt.annotate(
    "",
    xy=(ind[2] + bar_width,4),
    xytext=(ind[2] + bar_width, 2.2),
    arrowprops=dict(facecolor="black", shrink=0.02),
)
plt.text(ind[2] + bar_width + distance, 3.7, texts[2])
plt.annotate(
    "",
    xy=(ind[3] + bar_width * 2, 4),
    xytext=(ind[3] + bar_width * 2, 3.7),
    arrowprops=dict(facecolor="red", shrink=0.02),
    ha="center",
)
plt.text(ind[3] + bar_width * 2 + distance, 3.5, texts[3])
plt.axhline(y=yaxhline, color="blue", linestyle="--", linewidth=2)
# X-axis labels
plt.xticks(ind + bar_width / 2, months)

# Y-axis labels
plt.ylim(ylim)
plt.yticks(yticks)

# Legend
plt.legend(loc="upper center", bbox_to_anchor=(0.5, 1.15), ncol=2)

# Grid lines
plt.grid(axis="y")

# Labels and Title
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_227.pdf", bbox_inches="tight")

