
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Set seed for reproducibility
np.random.seed(0)

# Communication Mediums
categories = ["Email", "Phone", "Video Conference"]
values1 = [45, 65, 55]
values2 = [30, 50, 40]
values3 = [60, 35, 50]
values4 = [55, 45, 60]
values5 = [50, 55, 45]

values1minus = [-15, -20, -25]
values2minus = [-10, -15, -20]
values3minus = [-20, -25, -30]
values4minus = [-25, -30, -35]
values5minus = [-30, -35, -40]

# Set bar width
barWidth = 0.15

# Set position of bar on X axis
r1 = np.arange(len(values1))
r2 = [x + barWidth for x in r1]
r3 = [x + barWidth for x in r2]
r4 = [x + barWidth for x in r3]
r5 = [x + barWidth for x in r4]

# Labels and titles
labels = ["Method A", "Method B", "Method C", "Method D", "Method E"]
xlabel = "Communication Mediums"
ylabel = "Effectiveness Rating"
title = "Effectiveness of Different Communication Mediums"
annotation_texts_pos = ["45", "65", "55", "30", "50", "40", "60", "35", "50", "55", "45", "60", "50", "55", "45"]
annotation_texts_neg = ["15", "20", "25", "10", "15", "20", "20", "25", "30", "25", "30", "35", "30", "35", "40"]
yticks = np.arange(-50, 101, 20)
legend_labels = ["Method A", "Method B", "Method C", "Method D", "Method E"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set up the figure size
plt.figure(figsize=(8, 6))

# Bar plots
colors = ["#4e79a7", "#f28e2c", "#e15759", "#76b7b2", "#59a14f"]
for i, (r, values, minus_values, color, label) in enumerate(zip(
    [r1, r2, r3, r4, r5],
    [values1, values2, values3, values4, values5],
    [values1minus, values2minus, values3minus, values4minus, values5minus],
    colors,
    labels,
)):
    plt.bar(r, values, color=color, width=barWidth, edgecolor="black", label=label)
    plt.bar(r, minus_values, color=color, width=barWidth, edgecolor="grey", alpha=0.5) 

# Annotations
for i in range(len(r1)):
    plt.text(r1[i], values1[i] - 1, annotation_texts_pos[i], ha="center", va="top", rotation=-90)
    plt.text(r2[i], values2[i] - 1, annotation_texts_pos[i + 3], ha="center", va="top", rotation=-90)
    plt.text(r3[i], values3[i] - 1, annotation_texts_pos[i + 6], ha="center", va="top", rotation=-90)
    plt.text(r4[i], values4[i] - 1, annotation_texts_pos[i + 9], ha="center", va="top", rotation=-90)
    plt.text(r5[i], values5[i] - 1, annotation_texts_pos[i + 12], ha="center", va="top", rotation=-90)
    plt.text(r1[i], values1minus[i] + 1, annotation_texts_neg[i], ha="center", va="bottom", rotation=-90)
    plt.text(r2[i], values2minus[i] + 1, annotation_texts_neg[i + 3], ha="center", va="bottom", rotation=-90)
    plt.text(r3[i], values3minus[i] + 1, annotation_texts_neg[i + 6], ha="center", va="bottom", rotation=-90)
    plt.text(r4[i], values4minus[i] + 1, annotation_texts_neg[i + 9], ha="center", va="bottom", rotation=-90)
    plt.text(r5[i], values5minus[i] + 1, annotation_texts_neg[i + 12], ha="center", va="bottom", rotation=-90)

# Add xticks on the middle of the group bars
plt.xlabel(xlabel)
plt.xticks([r + 2 * barWidth for r in range(len(values1))], categories)
plt.yticks(yticks)

# Add title and labels
plt.ylabel(ylabel)
plt.title(title)

# Create legend & Show graphic
plt.legend()

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_228.pdf", bbox_inches="tight")
