
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data
categories = ["T=0", "T=10", "T=20"]
values1 = [10.2, 15.8, 14.3]
values2 = [9.5, 16.8, 15.2]
values3 = [11.0, 17.1, 13.4]
values4 = [10.8, 15.5, 14.7]
values5 = [9.9, 16.0, 15.6]

values1minus = [-2, -3, -4]
values2minus = [-1, -2, -3]
values3minus = [-2, -2, -4]
values4minus = [-3, -3, -3]
values5minus = [-1, -2, -2]

# Set up the bar width
barWidth = 0.15

# Set position of bar on X axis
r1 = np.arange(len(values1))
r2 = [x + barWidth for x in r1]
r3 = [x + barWidth for x in r2]
r4 = [x + barWidth for x in r3]
r5 = [x + barWidth for x in r4]

labels = ["Trial A", "Trial B", "Trial C", "Trial D", "Trial E"]
xlabel = "Time Points"
ylabel = "Concentration Levels"
yticks = np.arange(-5, 21, 5)
title = "Concentration Over Time"
supertitle = "Scientific Experiment Results"
legend_labels = ["Positive Concentrations", "Negative Concentrations"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set up the figure size
plt.figure(figsize=(8, 6))

# Make the plot with optimized colors and styles
plt.bar(r1, values1, color="#1f77b4", width=barWidth, edgecolor="black", label=labels[0])
plt.bar(r2, values2, color="#ff7f0e", width=barWidth, edgecolor="black", label=labels[1])
plt.bar(r3, values3, color="#2ca02c", width=barWidth, edgecolor="black", label=labels[2])
plt.bar(r4, values4, color="#d62728", width=barWidth, edgecolor="black", label=labels[3])
plt.bar(r5, values5, color="#9467bd", width=barWidth, edgecolor="black", label=labels[4])
plt.bar(r1, values1minus, color="#1f77b4", width=barWidth, edgecolor="grey", alpha=0.5)
plt.bar(r2, values2minus, color="#ff7f0e", width=barWidth, edgecolor="grey", alpha=0.5)
plt.bar(r3, values3minus, color="#2ca02c", width=barWidth, edgecolor="grey", alpha=0.5)
plt.bar(r4, values4minus, color="#d62728", width=barWidth, edgecolor="grey", alpha=0.5)
plt.bar(r5, values5minus, color="#9467bd", width=barWidth, edgecolor="grey", alpha=0.5)

# Add text on the top of each bar
for i in range(len(r1)):
    plt.text(r1[i], values1[i] - 0.5, str(values1[i]), ha="center", va="top", rotation=90, fontsize=8)
    plt.text(r2[i], values2[i] - 0.5, str(values2[i]), ha="center", va="top", rotation=90, fontsize=8)
    plt.text(r3[i], values3[i] - 0.5, str(values3[i]), ha="center", va="top", rotation=90, fontsize=8)
    plt.text(r4[i], values4[i] - 0.5, str(values4[i]), ha="center", va="top", rotation=90, fontsize=8)
    plt.text(r5[i], values5[i] - 0.5, str(values5[i]), ha="center", va="top", rotation=90, fontsize=8)
    plt.text(r1[i], values1minus[i] + 0.5, str(-values1minus[i]), ha="center", va="bottom", rotation=90, fontsize=8)
    plt.text(r2[i], values2minus[i] + 0.5, str(-values2minus[i]), ha="center", va="bottom", rotation=90, fontsize=8)
    plt.text(r3[i], values3minus[i] + 0.5, str(-values3minus[i]), ha="center", va="bottom", rotation=90, fontsize=8)
    plt.text(r4[i], values4minus[i] + 0.5, str(-values4minus[i]), ha="center", va="bottom", rotation=90, fontsize=8)
    plt.text(r5[i], values5minus[i] - 0.5, str(-values5minus[i]), ha="center", va="top", rotation=90, fontsize=8)

# Add xticks on the middle of the group bars
plt.xlabel(xlabel)
plt.xticks([r + 2 * barWidth for r in range(len(values1))], categories)
plt.yticks(yticks)
plt.ylabel(ylabel)
plt.title(title)
plt.suptitle(supertitle)
plt.grid(True, linestyle='--', linewidth=0.5, alpha=0.7)
plt.legend(legend_labels, loc='upper right')

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_230.pdf", bbox_inches="tight")
