
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data
crop_types = [
    "Wheat",
    "Corn",
    "Soybeans",
    "Cotton",
    "Rice",
    "Barley",
    "Oats",
    "Rye",
    "Sorghum",
    "Sunflower",
]
acreage = [5000, 7000, 6700, 1200, 2300, 1800, 1500, 900, 2000, 1100]

# Axes Limits and Labels
xlabel_value = "Acreage (in thousands)"
ylabel_value = "Crop Types"
title = "Distribution of Crop Types by Acreage"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create horizontal bar chart
plt.figure(figsize=(12, 8))  # Adjust figure size to match new data's dimensions
plt.barh(crop_types, acreage, color=plt.cm.Greens(np.linspace(0.5, 1, len(crop_types))))  # Gradient green colors
plt.xlabel(xlabel_value, fontsize=14)
plt.ylabel(ylabel_value, fontsize=14)
plt.title(title, fontsize=18)

# Add data labels
for index, value in enumerate(acreage):
    plt.text(
        value + 50, index, str(value), va="center", fontsize=12
    )  # Adjust text position and font size

plt.yticks(rotation=0, fontsize=12)
plt.xticks(fontsize=12)

# Add gridlines
plt.grid(axis='x', linestyle='--', alpha=0.7)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_233.pdf", bbox_inches="tight")
