
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data
categories = ["Car", "Bus", "Train", "Bicycle", "Motorbike", "Walking", "Plane"]
synthetic_data = [-20, -35, -15, -10, -25, -5, -30]
human_data = [25, 20, 30, 15, 20, 10, 35]
labels = ["Synthetic data", "Human-authored data"]
xlabel = "Percentage (%)"
title = "Comparison of Transportation Preferences"


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axis
fig, ax = plt.subplots(figsize=(8, 6))  # Larger figure for better readability
# Color schemes
colors_human = ["#1f77b4", "#ff7f0e", "#2ca02c", "#d62728", "#9467bd", "#8c564b", "#e377c2"]
colors_synthetic = ["#aec7e8", "#ffbb78", "#98df8a", "#ff9896", "#c5b0d5", "#c7c7c7", "#f7b6d2"]

# Plot horizontal bar chart
ax.barh(categories, synthetic_data, color=colors_synthetic, edgecolor="black", label=labels[0], height=0.4)
ax.barh(categories, human_data, left=0, color=colors_human, edgecolor="black", label=labels[1], height=0.4)

# Add data labels
for i, (synthetic_val, human_val) in enumerate(zip(synthetic_data, human_data)):
    ax.text(synthetic_val, i, f"{abs(synthetic_val)}%", va="center", ha="right", color="black")
    ax.text(human_val, i, f"{human_val}%", va="center", ha="left", color="black")

# Remove y-axis tick marks
ax.tick_params(axis="y", which="both", left=False)

# Set x-axis limits
ax.set_xlim(min(synthetic_data) - 10, max(human_data) + 10)
ax.set_xticks([])

# Hide left and right spines
ax.spines["left"].set_visible(False)
ax.spines["right"].set_visible(False)

# Draw a vertical line at x=0
ax.axvline(0, color="black")

# Add text to x=0
ax.text(-4, len(categories), labels[0], ha="right", va="bottom")
ax.text(4, len(categories), labels[1], ha="left", va="bottom")

# Invert y-axis for better readability
ax.invert_yaxis()

# Add labels
ax.set_xlabel(xlabel)
ax.set_title(title)

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout
plt.tight_layout()
plt.savefig("bar_234.pdf", bbox_inches="tight")
