
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data
categories = ["Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday"]
synthetic_data = [-3, -5, -2, -6, -4, -3, -2]
human_data = [5, 7, 3, 8, 6, 5, 4]
labels = ["Synthetic Temperature Data", "Recorded Temperature Data"]
xlabel = "Temperature Variation"
title = "Temperature Variations Throughout the Week"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axis
fig, ax = plt.subplots(figsize=(8, 6))  # 576x432 pixels
colors_human = ["#FF6347", "#FF4500", "#FFA07A", "#FF7F50", "#FFA500", "#FF8C00", "#FF8243"]
colors_synthetic = ["#ADD8E6", "#87CEEB", "#00BFFF", "#1E90FF", "#4169E1", "#4682B4", "#5F9EA0"]

# Plot horizontal bar chart
ax.barh(categories, synthetic_data, color=colors_synthetic, edgecolor="black", label=labels[0])
ax.barh(categories, human_data, left=0, color=colors_human, edgecolor="black", label=labels[1])

# Add data labels
for i, (syn_val, hum_val) in enumerate(zip(synthetic_data, human_data)):
    ax.text(syn_val, i, f"{abs(syn_val)}°C", va="center", ha="right", color="black")
    ax.text(hum_val, i, f"{hum_val}°C", va="center", ha="left", color="black")

# Remove y-axis tick marks
ax.tick_params(axis="y", which="both", left=False)

# Set x-axis limits and labels
ax.set_xlim(min(synthetic_data) - 2, max(human_data) + 2)
ax.set_xlabel(xlabel)
ax.set_title(title)

# Hide left and right spines
ax.spines["left"].set_visible(False)
ax.spines["right"].set_visible(False)

# Draw a vertical line at x=0
ax.axvline(0, color="black")

# Add legend
ax.legend(loc="upper right")

# Invert y-axis
ax.invert_yaxis()

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout
plt.tight_layout()
plt.savefig("bar_235.pdf", bbox_inches="tight")
