
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data
categories = [
    "physics",
    "chemistry",
    "biology",
    "geology",
    "astronomy",
    "ecology",
    "genetics",
]

method_a_data = [
    -12,
    -20,
    -15,
    -10,
    -14,
    -8,
    -18,
]  # Method A findings (negative values for representation)
method_b_data = [22, 25, 18, 12, 20, 15, 19]  # Method B findings
labels = ["Method A", "Method B"]

# Text labels
xlabel = ''
ylabel = ''
title = 'Comparison of Two Scientific Methods'
supertitle = ''
annotation_texts = ['Method A', 'Method B']
legendlabels = ["Method A", "Method B"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axis
fig, ax = plt.subplots(figsize=(8, 6))  # 576x432 pixels

colors_method_a = [
    "#5d8aa8",
    "#e32636",
    "#ffbf00",
    "#9966cc",
    "#008b8b",
    "#9acd32",
    "#ff7f50",
]
colors_method_b = [
    "#4682b4",
    "#cd5c5c",
    "#ffd700",
    "#dda0dd",
    "#20b2aa",
    "#adff2f",
    "#ff6347",
]

# Plot horizontal bar chart
ax.barh(
    categories,
    method_a_data,
    color=colors_method_a,
    edgecolor="black",
    label=legendlabels[0],
)
ax.barh(
    categories,
    method_b_data,
    left=0,
    color=colors_method_b,
    edgecolor="black",
    label=legendlabels[1],
)

# Add data labels
for i, (a_val, b_val) in enumerate(zip(method_a_data, method_b_data)):
    ax.text(
        a_val, i, f"{abs(a_val)}%", va="center", ha="right", color="black"
    )  # Use absolute value for Method A data
    ax.text(b_val, i, f"{b_val}%", va="center", ha="left", color="black")

# Remove y-axis tick marks
ax.tick_params(axis="y", which="both", left=False)

# Set x-axis limits
ax.set_xlim(min(method_a_data) - 10, max(method_b_data) + 10)
ax.set_xticks([])

# Hide left and right spines
ax.spines["left"].set_visible(False)
ax.spines["right"].set_visible(False)

# Draw a vertical line at x=0
ax.axvline(0, color="black")

# Add text to x=0
ax.text(-4, 7, annotation_texts[0], ha="right", va="bottom")
ax.text(4, 7, annotation_texts[1], ha="left", va="bottom")

# Invert y-axis
ax.invert_yaxis()

# Set titles and labels
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)
fig.suptitle(supertitle)

# Add legend
ax.legend(legendlabels)

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout
plt.tight_layout()
plt.savefig("bar_236.pdf", bbox_inches="tight")
