
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Business data for plotting
products = [
    "Product A", "Product B", "Product C", "Product D", "Product E",
    "Product F", "Product G", "Product H", "Product I", "Product J"
]
human_sales_estimate = [120, 150, 170, 100, 90, 110, 130, 125, 145, 160]
model_sales_prediction = [115, 140, 165, 105, 95, 120, 128, 130, 142, 158]

x = np.arange(len(products))  # the label locations
labels = ["Human Sales Estimate", "Model Sales Prediction"]
ylabel = "Sales (in units)"
xlabel = "Products"
title = "Sales Estimates vs Model Predictions"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(12, 8))

# Create the bars
for i in range(len(products)):
    ax.bar(
        x[i],
        human_sales_estimate[i],
        color="#2E8B57",
        label=labels[0] if i == 0 else "",
        hatch="///",
        edgecolor="black"
    )
    ax.bar(
        x[i],
        model_sales_prediction[i],
        bottom=human_sales_estimate[i],
        color="#4682B4",
        label=labels[1] if i == 0 else "",
        alpha=0.7,
        hatch="..",
        edgecolor="black"
    )

# Add some text for labels, title and custom x-axis tick labels, etc.
ax.set_ylabel(ylabel)
ax.set_title(title)
ax.set_xticks(x)
ax.set_xticklabels(products, rotation=45, ha="right")
ax.set_xlabel(xlabel)
ax.legend()

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("bar_237.pdf", bbox_inches="tight")
