
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data for plotting
words = [
    "happy", "sad", "anxious", "calm", "excited", "bored", "angry", 
    "relaxed", "stressed", "content", "fearful", "joyful", "nervous", 
    "peaceful", "upset", "optimistic", "pessimistic", "indifferent",
    "enthusiastic"
]
human_distribution = [
    0.2, 0.1, 0.15, 0.05, 0.1, 0.05, 0.05, 0.04, 0.1, 0.02, 0.03,
    0.07, 0.08, 0.02, 0.01, 0.04, 0.01, 0.02, 0.06
]
model_distribution = [
    0.12, 0.07, 0.1, 0.08, 0.09, 0.05, 0.07, 0.03, 0.09, 0.04, 0.06,
    0.05, 0.04, 0.06, 0.03, 0.05, 0.02, 0.02, 0.07
]

x = np.arange(len(words))  # the label locations
labels = ["Human Assessment", "Model Assessment"]
ylabel = "Probability"
title = "Assessment of Emotional States"
xlabel = "Emotional State"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(10, 8))  # Adjust the figure size to match the original image's dimensions

# Create the bars
for i in range(len(words)):
    ax.bar(
        x[i],
        human_distribution[i],
        color="#8B0000",  # Dark Red for human distribution
        label=labels[0] if i == 0 else "",
        hatch="///",
        edgecolor="black"
    )
    ax.bar(
        x[i],
        model_distribution[i],
        bottom=human_distribution[i],
        color="#4682B4",  # Steel Blue for model distribution
        label=labels[1] if i == 0 else "",
        alpha=0.7,
        hatch="..",
        edgecolor="black"
    )

# Add some text for labels, title, and custom x-axis tick labels, etc.
ax.set_ylabel(ylabel)
ax.set_title(title)
ax.set_xticks(x)
ax.set_xticklabels(words, rotation=45, ha="right")
ax.set_xlabel(xlabel)
ax.legend()

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout
plt.tight_layout()

plt.savefig("bar_239.pdf", bbox_inches="tight")
