
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.colors as mcolors
import matplotlib.ticker as ticker

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data
economic_sectors = [
    "Agriculture",
    "Manufacturing",
    "Services",
    "Construction",
    "Mining",
    "Technology",
]
gdp_contribution = [1500, 3500, 5500, 2000, 1200, 3000]

# Plot Configuration
xlabel = "GDP Contribution (in billions of $)"
xlim_values = (0, 6000)
ylim_values = (-0.5, 5.5)
title_text = "GDP Contribution by Economic Sector"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
yticks_rotation = 0
colors = [
    "#1f77b4",
    "#aec7e8",
    "#ff7f0e",
    "#ffbb78",
    "#2ca02c",
    "#98df8a",
]
# Create horizontal bar chart
plt.figure(figsize=(12, 8))  # Adjust figure size to match original image's dimensions
plt.barh(
    economic_sectors, gdp_contribution, color=colors, edgecolor="white"
)
plt.xlabel(xlabel, fontsize=12)
plt.xlim(*xlim_values)
plt.ylim(*ylim_values)
plt.title(title_text, fontsize=16)

basetick = [0, 1, 2, 3, 4, 5]
offsetticks = [-0.5, 0.5, 1.5, 2.5, 3.5, 4.5, 5.5]
plt.gca().yaxis.set_major_locator(ticker.FixedLocator(basetick))
plt.gca().yaxis.set_major_formatter(
    ticker.FuncFormatter(lambda x, _: f"{economic_sectors[x-1]}")
)
plt.gca().yaxis.set_minor_locator(ticker.FixedLocator(offsetticks))
plt.gca().grid(True, which="minor", axis="y", color="lightgrey", linestyle="--")
plt.gca().grid(True, which="major", axis="x", color="lightgrey", linestyle="--")
plt.gca().set_axisbelow(True)
plt.tick_params(axis="both", which="major", length=0)
plt.tick_params(axis="y", which="minor", color="gray", length=3)
plt.gca().spines["top"].set_visible(False)
plt.gca().spines["right"].set_visible(False)
plt.gca().spines["bottom"].set_visible(False)
plt.gca().spines["left"].set_visible(False)
plt.yticks(rotation=yticks_rotation)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("bar_246.pdf", bbox_inches="tight")
