
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Population Data Example
categories = [
    "Child Population",
    "Adult Population",
    "Senior Population",
    "Urban Population",
    "Rural Population",
    "Male Population",
    "Female Population",
][::-1]
north_america_data = [10, 50, 20, 60, 30, 55, 45][::-1]
europe_data = [8, 52, 25, 70, 20, 50, 50][::-1]
asia_data = [30, 120, 40, 200, 60, 110, 150][::-1]
africa_data = [40, 80, 15, 50, 70, 65, 75][::-1]
south_america_data = [12, 45, 10, 55, 40, 40, 42][::-1]
labels = ["North America", "Europe", "Asia", "Africa", "South America"]

# Labels and Titles
xlabel = "Population (in millions)"
ylabel = "Categories"
title = "Population Distribution by Region"
supertitle = "Demographic Data Visualization"
legendlabels = labels

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Stacked Bar Chart
fig, ax = plt.subplots(
    figsize=(10, 6)
)
bar_width = 0.5
y_pos = range(len(categories))

ax.barh(y_pos, north_america_data, bar_width, color="#ff9999", label=labels[0])
ax.barh(y_pos, europe_data, bar_width, left=north_america_data, color="#66b3ff", label=labels[1])
ax.barh(
    y_pos,
    asia_data,
    bar_width,
    left=[i + j for i, j in zip(north_america_data, europe_data)],
    color="#99ff99",
    label=labels[2],
)
ax.barh(
    y_pos,
    africa_data,
    bar_width,
    left=[i + j + k for i, j, k in zip(north_america_data, europe_data, asia_data)],
    color="#ffcc99",
    label=labels[3],
)
ax.barh(
    y_pos,
    south_america_data,
    bar_width,
    left=[
        i + j + k + l for i, j, k, l in zip(north_america_data, europe_data, asia_data, africa_data)
    ],
    color="#c2c2f0",
    label=labels[4],
)

# Labels and Legend
ax.set_xticks(np.arange(0, 501, 50))
ax.set_yticks(y_pos)
ax.grid(axis="x", color="gray", linestyle="--")
ax.set_axisbelow(True)
ax.set_yticklabels(categories)
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)
fig.suptitle(supertitle, fontsize=14)
ax.legend(loc="upper center", bbox_to_anchor=(0.5, 1.2), ncols=3)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("bar_250.pdf", bbox_inches="tight")
