
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)  # Ensure reproducibility
# Psychology Data Example
categories = [
    "Happiness Index",
    "Stress Levels",
    "Mental Health Services",
    "Work-Life Balance",
    "Physical Activity",
    "Social Support",
    "Average Sleep Hours"
][::-1]

us_data = [7.8, 5.1, 6.5, 8.0, 7.0, 6.8, 7.2][::-1]
eu_data = [7.5, 4.8, 6.2, 7.8, 6.7, 6.5, 7.1][::-1]
china_data = [6.2, 6.5, 5.5, 6.0, 6.0, 5.8, 6.5][::-1]
india_data = [6.0, 7.0, 4.5, 5.8, 5.5, 5.2, 6.0][::-1]
brazil_data = [6.8, 6.0, 5.0, 6.2, 6.0, 6.1, 6.7][::-1]
labels = ["US", "EU", "China", "India", "Brazil"]

xlabel = "Index Value"
ylabel = "Psychological Metrics"
title = "Psychological Metrics Across Different Regions"
legendlabels = labels

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Stacked Bar Chart
fig, ax = plt.subplots(figsize=(10, 6))

bar_width = 0.5
y_pos = range(len(categories))

ax.barh(y_pos, us_data, bar_width, color="#4E79A7", label=labels[0])
ax.barh(y_pos, eu_data, bar_width, left=us_data, color="#F28E2B", label=labels[1])
ax.barh(
    y_pos,
    china_data,
    bar_width,
    left=[i + j for i, j in zip(us_data, eu_data)],
    color="#E15759",
    label=labels[2],
)
ax.barh(
    y_pos,
    india_data,
    bar_width,
    left=[i + j + k for i, j, k in zip(us_data, eu_data, china_data)],
    color="#76B7B2",
    label=labels[3],
)
ax.barh(
    y_pos,
    brazil_data,
    bar_width,
    left=[
        i + j + k + l for i, j, k, l in zip(us_data, eu_data, china_data, india_data)
    ],
    color="#59A14F",
    label=labels[4],
)

# Labels and Legend
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_xticks(np.arange(0, 40, 5))
ax.set_yticks(y_pos)
ax.grid(axis="x", color="gray", linestyle="--")
ax.set_axisbelow(True)
ax.set_yticklabels(categories)
ax.legend(loc="upper center", bbox_to_anchor=(0.5, 1.15), ncols=3)
ax.set_title(title)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("bar_251.pdf", bbox_inches="tight")
