
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
category_names = ["Realism", "Idealism", "Pragmatism", "Existentialism", "Postmodernism"]
results = {
    "Athens": [20, 15, 25, 25, 15],
    "Paris": [10, 30, 20, 10, 30],
    "London": [25, 20, 15, 25, 15],
    "New York": [30, 15, 25, 10, 20],
    "Tokyo": [10, 25, 20, 30, 15],
}
xlim = [-90, 90]
xticks = np.arange(-90, 91, 10)
xvline = 0

xlabel = "Frequency (in %)"
ylabel = "Cities"
title = "Popularity of Philosophical Schools in Different Cities"

def create_bar_chart(results, category_names):
    fig, ax = plt.subplots(figsize=(10, 6))

    labels = list(results.keys())
    data = np.array(list(results.values()))
    data_cum = data.cumsum(axis=1)
    middle_index = data.shape[1] // 2
    offsets = data[:, range(middle_index)].sum(axis=1) + data[:, middle_index] / 2

    # Color Mapping
    category_colors = ["#8c564b", "#2ca02c", "#d62728", "#9467bd", "#1f77b4"]

    # Plot Bars
    for i, (colname, color) in enumerate(zip(category_names, category_colors)):
        widths = data[:, i]
        starts = data_cum[:, i] - widths - offsets
        rects = ax.barh(
            labels,
            widths,
            left=starts,
            height=0.5,
            label=colname,
            color=color,
            edgecolor="black",
        )

    # Add Zero Reference Line
    ax.axvline(xvline, linestyle="--", color="black", alpha=0.5)

    # X Axis
    ax.set_xlabel(xlabel)
    ax.set_xlim(xlim)
    ax.set_xticks(xticks)
    ax.xaxis.set_major_formatter(lambda x, pos: str(abs(int(x))))

    # Y Axis
    ax.set_ylabel(ylabel)
    ax.invert_yaxis()

    # Remove spines
    ax.spines["right"].set_visible(False)
    ax.spines["top"].set_visible(False)
    ax.spines["left"].set_visible(False)

    # Legend
    ax.legend(ncol=len(category_names), bbox_to_anchor=(0.5, 1.1), loc="upper center")

    # Title
    ax.set_title(title, fontsize=14)

    # Set Background Color
    fig.set_facecolor("#F5F5F5")

    return fig, ax


# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = create_bar_chart(results, category_names)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("bar_253.pdf", bbox_inches="tight")
