
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data for the plots (Approval ratings for politicians)
politicians = ["Politician A", "Politician B", "Politician C", "Politician D", "Politician E"]
approval_ratings = [45.3, -30.2, 20.1, -10.5, 15.8]

# Axes Limits and Labels
chart_title = "Approval Ratings of Politicians"
xticks_range = range(-40, 51, 10)
x_axis_label = "Approval Rating (%)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size to match the original image's dimensions
fig, ax = plt.subplots(figsize=(10, 8))

# Plot for Approval Ratings
colors = ['#1f77b4', '#ff7f0e', '#2ca02c', '#d62728', '#9467bd']
hatches = ['', '\\\\', '', '\\\\', '']
bars = ax.barh(politicians, approval_ratings, color=colors, edgecolor="black")

for bar, value, hatch in zip(bars, approval_ratings, hatches):
    if value < 0:
        bar.set_hatch(hatch)
        bar.set_edgecolor("red")
ax.set_title(chart_title, fontsize=16)
for i, v in enumerate(approval_ratings):
    ax.text(
        v - 1 if v < 0 else v + 1,
        i,
        f"{v}%",
        color="black" if v > 0 else "red",
        va="center",
        ha="right" if v < 0 else "left",
        fontsize=12
    )

# Add a vertical line at x=0
ax.axvline(0, color="black", linewidth=0.8)
ax.set_xticks(xticks_range)
# Remove y-axis tick marks
ax.tick_params(axis="y", which="both", left=False)

# Hide all axes except the bottom one
for spine in ["left", "right", "top"]:
    ax.spines[spine].set_visible(False)

# Add x-axis label
ax.set_xlabel(x_axis_label, fontsize=14)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_260.pdf", bbox_inches="tight")
