
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data
categories = [
    "Social Media Usage",
    "Video Conferencing Adoption",
    "Messaging App Downloads",
]
social_media_usage = [720, 866, 950]  # Example data in percentage
video_conferencing_adoption = [650, 780, 860]  # Example data in percentage
messaging_app_downloads = [800, 700, 920]  # Example data in numbers
labels = [
    "Social Media Usage (%)",
    "Video Conferencing Adoption (%)",
    "Messaging App Downloads (Mil)",
]
xticks = np.arange(0, 2500, 250)
xlabel = 'Communication Metrics'
ylabel = 'Categories'
title = 'Communication Technologies Adoption'
legend_labels = ['Social Media', 'Video Conferencing', 'Messaging Apps']

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Stacked Bar Chart
fig, ax = plt.subplots(figsize=(10, 6))
bar_width = 0.5
y_pos = range(len(categories))

ax.barh(
    y_pos,
    social_media_usage,
    bar_width,
    color="#4c72b0",
    edgecolor="#f7f7f7",
    hatch="*",
    label=legend_labels[0],
)
ax.barh(
    y_pos,
    video_conferencing_adoption,
    bar_width,
    left=social_media_usage,
    color="#dd8452",
    edgecolor="#f7f7f7",
    hatch="+",
    label=legend_labels[1],
)
ax.barh(
    y_pos,
    messaging_app_downloads,
    bar_width,
    left=[i + j for i, j in zip(social_media_usage, video_conferencing_adoption)],
    color="#55a868",
    edgecolor="#f7f7f7",
    hatch="/",
    label=legend_labels[2],
)

# Labels and Legend
ax.set_xticks(xticks)
ax.set_yticks(y_pos)
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)
ax.set_yticklabels(categories)
ax.grid(axis="x", color="gray", linestyle="--")
ax.set_axisbelow(True)
ax.legend(loc="upper center", bbox_to_anchor=(0.5, 1.2), ncols=3)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_262.pdf", bbox_inches="tight")
