
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# New Sample data for illustrating renewable energy efficiency over time
categories = [
    "Solar",
    "Wind",
    "Hydro",
    "Geothermal",
    "Biomass",
]
scores_0 = [0.65, 0.55, 0.70, 0.50, 0.40]
scores_20 = [0.75, 0.65, 0.75, 0.55, 0.45]
scores_40 = [0.80, 0.70, 0.80, 0.60, 0.50]
scores_60 = [0.85, 0.75, 0.85, 0.65, 0.55]
labels = ["Year 0", "Year 20", "Year 40", "Year 60"]
xlabel = "Efficiency (%)"
ylabel = "Renewable Energy Sources"
title = "Efficiency of Renewable Energy Sources Over Time"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Size of the plot
plt.figure(figsize=(10, 8))

# Adjust the position of the bars on the x-axis to prevent overlap
bar_height = 0.15
ind = [i * (bar_height * len(categories)) for i in range(len(scores_0))]

# Creating the bar plot with adjusted positions to prevent overlap
plt.barh(
    [pos + bar_height * 0 for pos in ind],
    scores_0,
    color="#2E8B57",  # SeaGreen
    height=bar_height,
    label=labels[0],
)
plt.barh(
    [pos + bar_height * 1 for pos in ind],
    scores_20,
    color="#3CB371",  # MediumSeaGreen
    height=bar_height,
    label=labels[1],
)
plt.barh(
    [pos + bar_height * 2 for pos in ind],
    scores_40,
    color="#66CDAA",  # MediumAquamarine
    height=bar_height,
    label=labels[2],
)
plt.barh(
    [pos + bar_height * 3 for pos in ind],
    scores_60,
    color="#8FBC8B",  # DarkSeaGreen
    height=bar_height,
    label=labels[3],
)

# X and Y axis Labels
plt.xlabel(xlabel)
plt.ylabel(ylabel)

# Title of the plot
plt.title(title)

# Adding legend
plt.legend()

# Adding a grid for better readability
plt.grid(axis='x', linestyle='--', alpha=0.7)

# Setting the labels for y-axis with adjusted positions
plt.yticks([pos + bar_height * 1.5 for pos in ind], categories)

# ===================
# Part 4: Saving Output
# ===================
# Display the plot with enough space
plt.tight_layout()

plt.savefig("bar_268.pdf", bbox_inches="tight")
