
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Education data for average grades
schools = ["School A", "School B", "School C", "School D"]
math_grades = np.array([85, 90, 78, 92]) + np.random.rand(4) * 5  # Math grades
science_grades = np.array([80, 88, 82, 91]) + np.random.rand(4) * 5  # Science grades
english_grades = np.array([87, 85, 90, 93]) + np.random.rand(4) * 5  # English grades
history_grades = np.array([79, 84, 89, 88]) + np.random.rand(4) * 5  # History grades

labels = ["Math", "Science", "English", "History"]
xlabel = "Average Grades"
ylabel = "Schools"
title = "Average Grades by Subject and School"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Size of the plot
plt.figure(figsize=(10, 7))

# Adjust the position of the bars on the x-axis to prevent overlap
bar_height = 0.3
indices = np.arange(len(math_grades)) * 1.5  # Increase space between groups

# Define some hatch patterns and colors to use for bars
hatch_patterns = ["/", "\\", "|", "-", "+", "*"]
colors = ["#4daf4a", "#377eb8", "#ff7f00", "#984ea3"]

# Plot bars for each subject's average grades
for i, grades in enumerate([math_grades, science_grades, english_grades, history_grades]):
    bars = plt.barh(
        [pos + bar_height * i for pos in indices],
        grades,
        color=colors[i],
        height=bar_height,
        hatch=hatch_patterns[i],
        label=f"{labels[i]}",
    )

    # Add text annotations to the right of the bars
    for bar in bars:
        plt.text(
            bar.get_width(),  # X position
            bar.get_y() + bar.get_height() / 2,  # Y position
            f"{bar.get_width():.2f}",  # Text to display
            va="center",
        )

# X and Y axis Labels and limits
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.xlim(
    0,
    max(np.max(math_grades), np.max(science_grades), np.max(english_grades), np.max(history_grades))
    + 10,
)

# Title of the plot
plt.title(title)

# Adding legend
plt.legend()

# Setting the labels for y-axis with adjusted positions
plt.yticks([pos + bar_height * 1.5 for pos in indices], schools)

# Adding grids
plt.grid(True, linestyle="--", which="both", axis="x", color="grey", alpha=0.7)

# ===================
# Part 4: Saving Output
# ===================
# Display the plot with enough space
plt.tight_layout()

# Save the plot as a PDF file
plt.savefig("bar_271.pdf", bbox_inches="tight")
