
# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Technology performance metrics across regions
regions = ["North", "South", "East", "West"]
cpu_usage = np.array([75, 65, 80, 70]) + np.random.rand(4) * 5  # CPU usage in %
memory_usage = np.array([65, 70, 60, 85]) + np.random.rand(4) * 5  # Memory usage in %
disk_io = np.array([40, 55, 50, 65]) + np.random.rand(4) * 5  # Disk I/O in MB/s
network_latency = np.array([20, 25, 15, 30]) + np.random.rand(4) * 3  # Network latency in ms

labels = ["CPU Usage (%)", "Memory Usage (%)", "Disk I/O (MB/s)", "Network Latency (ms)"]
xlabel = "Metrics"
ylabel = "Regions"
title = "Technology Performance Metrics by Region"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Size of the plot
plt.figure(figsize=(10, 7))

# Adjust the position of the bars on the x-axis to prevent overlap
bar_height = 0.3
indices = np.arange(len(cpu_usage)) * 1.5  # Increase space between groups

# Define new color palette and hatch patterns for technology theme
hatch_patterns = ["/", "\\", "|", "-", "+", "*"]
colors = ["#1f77b4", "#ff7f0e", "#2ca02c", "#d62728"]

# Plot bars for each performance metric
for i, level in enumerate([cpu_usage, memory_usage, disk_io, network_latency]):
    bars = plt.barh(
        [pos + bar_height * i for pos in indices],
        level,
        color=colors[i],
        height=bar_height,
        hatch=hatch_patterns[i],
        label=f"{labels[i]}",
    )

    # Add text annotations to the right of the bars
    for bar in bars:
        plt.text(
            bar.get_width(),  # X position
            bar.get_y() + bar.get_height() / 2,  # Y position
            f"{bar.get_width():.2f}",  # Text to display
            va="center",
        )

# X and Y axis labels and limits
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.xlim(
    0,
    max(np.max(cpu_usage), np.max(memory_usage), np.max(disk_io), np.max(network_latency))
    + 10,
)

# Title of the plot
plt.title(title)

# Adding legend
plt.legend()

# Setting the labels for y-axis with adjusted positions
plt.yticks([pos + bar_height * 1.5 for pos in indices], regions)

# Adding grids
plt.grid(True, linestyle="--", which="both", axis="x", color="grey", alpha=0.7)

# ===================
# Part 4: Saving Output
# ===================
# Display the plot with enough space
plt.tight_layout()

# Save the plot as a PDF file
plt.savefig("bar_272.pdf", bbox_inches="tight")

