
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Example religious data
categories = [
    "Weekly Attendance",
    "Charity Participation",
    "Festival Participation",
    "Community Service",
]
layer_data = {
    "Group A": np.array([80, 60, 75, 70]),
    "Group B": np.array([70, 80, 80, 60]),
    "Group C": np.array([55, 50, 45, 45]),
    "Group D": np.array([45, 60, 50, 75]),
}

title = "Stacked Bar Chart of Religious Group Participation"
xlabel = "Categories"
ylabel = "Percentage (%)"
legend_labels = ["Group A", "Group B", "Group C", "Group D"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================

# Colors for each layer (using serene and harmonious colors)
colors = ["#ff9999", "#66b3ff", "#99ff99", "#ffcc99"]

# Create the figure and axes objects
fig, ax = plt.subplots(figsize=(10, 6))

# Variables to store the bottom position for each stack
bottoms = np.array([0] * len(categories))

for i, (layer, values) in enumerate(layer_data.items()):
    bars = ax.bar(categories, values, bottom=bottoms, color=colors[i], label=layer)

    # Add data labels on each bar
    for bar, bottom in zip(bars, bottoms):
        height = bar.get_height()
        ax.text(
            bar.get_x() + bar.get_width() / 2,
            bottom + height / 2,
            str(height) + "%",
            ha="center",
            va="center",
            color="black",
            fontsize=9
        )

    # Update the bottoms position
    bottoms += values

# Chart title and labels
plt.title(title, fontsize=15, weight='bold')
plt.xlabel(xlabel, fontsize=12)
plt.ylabel(ylabel, fontsize=12)

# Adding legend
plt.legend(legend_labels, loc='upper right', frameon=True)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
# Save the plot as PDF
plt.savefig("bar_282.pdf", bbox_inches="tight")
