
# ===================
# Part 1: Importing Libraries
# ===================

import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Example energy data
categories = [
    "2015",
    "2016",
    "2017",
    "2018",
    "2019",
    "2020",
    "2021",
    "2022",
]
layer_data = {
    "Solar": np.array([35, 90, 85, 80, 70, 90, 80, 100]),
    "Wind": np.array([100, 90, 75, 80, 90, 80, 70, 90]),
    "Hydro": np.array([85, 45, 40, 75, 55, 75, 50, 65]),
    "Fossil Fuels": np.array([80, 75, 100, 65, 85, 55, 100, 45]),
}

title = "Stacked Bar Chart of Energy Production"
xlabel = "Years"
ylabel = "Energy Production (in GW)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================

# Colors for each layer (Solar: Yellow, Wind: Green, Hydro: Blue, Fossil Fuels: Gray)
colors = ["#ffdd57", "#7ac943", "#00a1e4", "#4d4d4d"]

# Create the figure and axes objects
fig, ax = plt.subplots(figsize=(12, 7))

# Variables to store the bottom position for each stack
bottoms = np.array([0] * len(categories))

for i, (layer, values) in enumerate(layer_data.items()):
    bars = ax.bar(categories, values, bottom=bottoms, color=colors[i], label=layer)

    # Add data labels on each bar
    for bar, bottom in zip(bars, bottoms):
        height = bar.get_height()
        ax.text(
            bar.get_x() + bar.get_width() / 2,
            bottom + height / 2,
            str(height),
            ha="center",
            va="center",
            color="white",
        )

    # Update the bottoms position
    bottoms += values

# Chart title and labels
plt.title(title)
plt.xlabel(xlabel)
plt.ylabel(ylabel)

# Adding legend
plt.legend()

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
# Save the plot as PDF
plt.savefig("bar_283.pdf", bbox_inches="tight")
