
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Sample data for technology domain
annotators = ["Reviewer 1", "Reviewer 2", "Reviewer 3", "Reviewer 4", "Reviewer 5", "Reviewer 6"]
scores = {
    "Reviewer 1": [80, 90, 92, 98, 90],
    "Reviewer 2": [79, 91, 100, 95, 85],
    "Reviewer 3": [87, 100, 88, 85, 90],
    "Reviewer 4": [86, 92, 94, 88, 100],
    "Reviewer 5": [93, 80, 97, 92, 88],
    "Reviewer 6": [78, 98, 94, 87, 93],
}

title = "Gadget Review Scores by Various Reviewers"
xlabel = "Reviewer"
ylabel = "Scores"
ylim = [0, 450]
yticks = range(0, 451, 50)
score_labels = [f"Gadget {i+1}" for i in range(5)]
legendtitle = "Gadgets"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Define a color map for gradients
cmap = plt.get_cmap("cool")

fig, ax = plt.subplots(figsize=(10, 6))  # Adjusting figure size

for i, annotator in enumerate(annotators):
    bottom = 0
    score_list = scores[annotator]
    for j, score in enumerate(score_list):
        color = cmap(
            1 - j / len(score_list)
        )  # Determine color based on position in list
        bar = ax.bar(annotator, score, bottom=bottom, color=color)
        bottom += score
        # Annotate each segment
        if j == len(score_list) - 1:
            ax.text(
                bar[0].get_x() + bar[0].get_width() / 2,
                bottom - score / 2,
                str(score),
                ha="center",
                va="bottom",
                color="black",
            )
        else:
            ax.text(
                bar[0].get_x() + bar[0].get_width() / 2,
                bottom - score / 2,
                str(score),
                ha="center",
                va="center",
                color="white",
            )

# Adding title and labels
ax.set_title(title, fontsize=15, fontweight='bold')
ax.set_xlabel(xlabel, fontsize=12)
ax.set_ylabel(ylabel, fontsize=12)
ax.set_ylim(ylim)  # Adjusting limit to make space for text annotations
ax.set_yticks(yticks)

# Adding legend with score indications
ax.legend(score_labels, title=legendtitle, bbox_to_anchor=(1.05, 1), loc="upper left", fontsize=10, title_fontsize='13')
ax.yaxis.grid(linestyle="--", color='gray')

ax.spines["top"].set_visible(False)
ax.spines["right"].set_visible(False)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("bar_288.pdf", bbox_inches="tight")

