
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Sample data
cities = ["City A", "City B", "City C", "City D", "City E", "City F"]
tourists = {
    "City A": [210, 310, 180, 225, 190],
    "City B": [240, 330, 150, 270, 220],
    "City C": [180, 280, 200, 230, 210],
    "City D": [300, 270, 190, 250, 200],
    "City E": [250, 330, 210, 280, 160],
    "City F": [290, 240, 230, 315, 180],
}

title = "Tourist Visit Data (2023)"
xlabel = "Cities"
ylabel = "Number of Tourists"
ylim = [0, 1200]
yticks = range(0, 1300, 200)
tourist_labels = ["January", "February", "March", "April", "May"]
legendtitle = "Months"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Define a color map for gradients
cmap = plt.get_cmap("coolwarm")

fig, ax = plt.subplots(figsize=(10, 6))  # Adjusting figure size

for i, city in enumerate(cities):
    bottom = 0
    tourist_list = tourists[city]
    for j, tourist in enumerate(tourist_list):
        color = cmap(j / len(tourist_list))  # Determine color based on position in list
        bar = ax.bar(city, tourist, bottom=bottom, color=color)
        bottom += tourist
        # Annotate each segment
        if j == len(tourist_list) - 1:
            ax.text(
                bar[0].get_x() + bar[0].get_width() / 2,
                bottom - tourist / 2,
                str(tourist),
                ha="center",
                va="bottom",
                color="black",
            )
        else:
            ax.text(
                bar[0].get_x() + bar[0].get_width() / 2,
                bottom - tourist / 2,
                str(tourist),
                ha="center",
                va="center",
                color="white",
            )

# Adding title and labels
ax.set_title(title)
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_ylim(ylim)  # Adjusting limit to make space for text annotations
ax.set_yticks(yticks)

# Adding legend with month indications
ax.legend(tourist_labels, title=legendtitle, bbox_to_anchor=(1.05, 1), loc="upper left")
ax.yaxis.grid(linestyle="--", color="gray", alpha=0.7)

ax.spines["top"].set_visible(False)
ax.spines["right"].set_visible(False)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("bar_289.pdf", bbox_inches="tight")
