
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Data
import numpy as np

np.random.seed(1)  # Setting a different seed for new data

categories = ["Poetry", "Fiction", "Non-Fiction", "Drama", "Science Fiction", "Fantasy", "Biography"]
# Generate three lists
RegOpt, BIOpt, LoopOpt = np.random.dirichlet(np.ones(3), size=len(categories)).T

RegOpt = RegOpt * 100
BIOpt = BIOpt * 100
LoopOpt = LoopOpt * 100

labels = ["Character Development", "Plot Complexity", "World-Building"]
yticks = np.arange(0, 101, 20)
ylim = [0, 100]

# Text labels
xlabel = "Literature Genres"
ylabel = "Optimization Parameters (%)"
title = "Literature Genre Analysis"
legendlabels = ["Character Development", "Plot Complexity", "World-Building"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Stacked bar chart setup
bar_width = 0.9
r = np.arange(len(categories))

# Plot
fig, ax = plt.subplots(figsize=(10, 6))
bar1 = ax.bar(
    r,
    RegOpt,
    color="#c0a9cf",
    edgecolor="white",
    hatch="//",
    width=bar_width,
    label=labels[0],
)
bar2 = ax.bar(
    r,
    BIOpt,
    bottom=RegOpt,
    color="#98c1d9",
    edgecolor="white",
    hatch="xx",
    width=bar_width,
    label=labels[1],
)
bar3 = ax.bar(
    r,
    LoopOpt,
    bottom=RegOpt + BIOpt,
    color="#66c2a5",
    edgecolor="white",
    hatch="..",
    width=bar_width,
    label=labels[2],
)

ax.set_xticks(r)
ax.set_xticklabels(categories, rotation=-45, ha="left")
ax.set_yticks(yticks)
ax.set_ylim(ylim)
ax.set_yticklabels(["{}%".format(i) for i in range(0, 101, 20)])
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)
ax.legend(loc="upper center", bbox_to_anchor=(0.5, 1.15), ncol=3)

ax.spines["top"].set_visible(False)
ax.spines["right"].set_visible(False)
ax.spines["left"].set_visible(False)
ax.spines["bottom"].set_visible(False)
# Grid lines
ax.yaxis.grid(True, linestyle="--", color="gray", alpha=0.7)

# ===================
# Part 4: Saving Output
# ===================
# Show plot
plt.tight_layout()
plt.savefig("bar_292.pdf", bbox_inches="tight")
