
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Set a seed for reproducibility

# Define fiscal quarters
quarters = np.array([1, 2, 3, 4, 5])

# Generate synthetic revenue changes for two art galleries
revenue_changes_gallery_a = np.random.uniform(-10, 10, 5)  # Example % change in revenue for Gallery A
revenue_changes_gallery_b = np.random.uniform(-10, 10, 5)  # Example % change in revenue for Gallery B

# Labels and other textual content
labels = ["Gallery A", "Gallery B"]
axline = 0
xlabel = "Fiscal Quarter"
ylabel = "Revenue Change (%)"
title = "Quarterly Revenue Changes of Art Galleries"
ylim = [-10, 10]
yticks = np.arange(-10, 11, 5)

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and subplots
fig, axs = plt.subplots(figsize=(10, 5))
width = 0.4

# Color scheme for the bars
colors = ['#ff9999','#66b3ff']

# Plotting bars for each gallery
bars1 = axs.bar(
    quarters - width / 2,
    revenue_changes_gallery_a,
    width=width,
    color=colors[0],
    label="Gallery A",
)
bars2 = axs.bar(
    quarters + width / 2,
    revenue_changes_gallery_b,
    width=width,
    color=colors[1],
    label="Gallery B",
)

# Adding text labels on the bars
for bars in [bars1, bars2]:
    for bar in bars:
        height = bar.get_height()
        axs.text(
            bar.get_x() + bar.get_width() / 2,
            height,
            f"{height:.1f}",
            ha="center",
            va="bottom" if height > 0 else "top",
        )

# Additional plot settings
axs.axhline(axline, color="black")
axs.set_xlabel(xlabel)
axs.set_ylabel(ylabel)
axs.set_title(title, fontsize=14)
axs.set_ylim(ylim)
axs.set_yticks(yticks)
axs.set_xticks(quarters)
axs.yaxis.grid(True)
axs.set_axisbelow(True)

# Adding legend and adjusting layout
plt.legend(loc="upper center", bbox_to_anchor=(0.5, 1.10), ncol=2)

# ===================
# Part 4: Saving Output
# ===================
# Save the figure as a PDF
plt.tight_layout()
plt.savefig("bar_297.pdf", bbox_inches="tight")
