
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data
categories = ["Managers", "Employees", "Clients"]
methods = ["Email", "In-Person", "Phone", "Webinar", "Social Media"]
scores = [
    [75, 85, 65],
    [60, 70, 55],
    [50, 60, 45],
    [40, 50, 35],
    [30, 40, 25],
]

neg_scores = [
    [-15, -10, -20],
    [-15, -10, -15],
    [-10, -15, -10],
    [-5, -10, -5],
    [0, 0, 0],
]

xlabel = "Communication Methods"
yticks = np.arange(-30, 101, 10)
ylabel = "Effectiveness Score"
legendtitle = "Groups"

# Styling Texts
title = "Effectiveness of Communication Methods"
suptitle = "Survey Data"
annotation_text = "Survey conducted in 2023"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = ["#4E79A7", "#F28E2C", "#E15759", "#76B7B2", "#59A14F"]

plt.figure(figsize=(12, 6))
barWidth = 0.15
positions = np.arange(len(methods))

for i, category in enumerate(categories):
    pos = [x + barWidth * i for x in positions]
    plt.bar(
        pos,
        [v[i] for v in scores],
        color=colors[i],
        width=barWidth,
        edgecolor="grey",
        label=category,
    )
    plt.bar(
        pos,
        [v[i] for v in neg_scores],
        color=colors[i],
        width=barWidth,
        edgecolor="grey",
        alpha=0.5,
    )

    for idx, val in enumerate(pos):
        plt.text(
            val,
            scores[idx][i] - 2,
            f"{scores[idx][i]}",
            ha="center",
            va="top",
            rotation=-90,
        )
        plt.text(
            val,
            neg_scores[idx][i] + 1,
            f"{-neg_scores[idx][i]}",
            ha="center",
            va="bottom",
            rotation=-90,
        )

plt.xlabel(xlabel)
plt.xticks([r + barWidth for r in range(len(methods))], methods)
plt.yticks(yticks)
plt.ylabel(ylabel)
plt.legend(title=legendtitle, loc='upper right')
plt.title(title, fontsize=14)
plt.suptitle(suptitle, fontsize=16)
plt.annotate(annotation_text, (0, 1), (0, -20), fontsize=10, 
             xycoords='axes fraction', textcoords='offset points', va='top')

plt.tight_layout()
plt.savefig("bar_301.pdf", bbox_inches="tight")
