
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data
categories = ["Treatment A", "Treatment B", "Placebo"]
# Example Psychology Dataset: Subjective Stress Levels (higher is worse)
values1 = [25, 30, 45]
values2 = [35, 29, 39]
values3 = [28, 34, 31]
values4 = [40, 33, 36]
values5 = [32, 28, 30]

# Example Negative Values: Subjective Satisfaction Levels (higher is better)
values1minus = [-15, -20, -10]
values2minus = [-10, -15, -12]
values3minus = [-18, -16, -14]
values4minus = [-20, -22, -18]
values5minus = [-13, -12, -10]

values = [values1, values2, values3, values4, values5]
values_minus = [values1minus, values2minus, values3minus, values4minus, values5minus]
labels = ["Session 1", "Session 2", "Session 3", "Session 4", "Session 5"]
xlabel = "Sessions"
yticks = np.arange(-25, 51, 10)
ylabel = "Levels"
legendtitle = "Treatments"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = ["#a6cee3", "#1f78b4", "#b2df8a", "#33a02c", "#fb9a99"]
# Set up the figure size
plt.figure(figsize=(10, 5))

# Set up the bar width
barWidth = 0.2

# Set up positions for the bars
positions = np.arange(len(labels))

# Creating bars for each category
for i, category in enumerate(categories):
    pos = [x + barWidth * i for x in positions]  # shift each bar by `barWidth * i`
    plt.bar(
        pos,
        [v[i] for v in values],
        color=colors[i],
        width=barWidth,
        edgecolor="black",
        label=category,
    )
    plt.bar(
        pos,
        [v[i] for v in values_minus],
        color=colors[i],
        width=barWidth,
        edgecolor="black",
        alpha=0.5,
        hatch='//'
    )

    # Add text on top and bottom of the bars
    for idx, val in enumerate(pos):
        plt.text(
            val,
            values[idx][i] - 1,
            f"{values[idx][i]}",
            ha="center",
            va="top",
            rotation=0,
        )
        plt.text(
            val,
            values_minus[idx][i] + 1,
            f"{-values_minus[idx][i]}",
            ha="center",
            va="bottom",
            rotation=0,
        )

# Adding axis labels and ticks
plt.xlabel(xlabel)
plt.xticks([r + barWidth * 1.0 for r in range(len(labels))], labels)
plt.yticks(yticks)

# Add a legend and display the plot
plt.ylabel(ylabel)
plt.legend(title=legendtitle)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_302.pdf", bbox_inches="tight")
