
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data for the bar charts
country_a_tourists = [120, 150, 180, 110]
country_b_tourists = [80, 100, 130, 90]
x = np.arange(len(country_a_tourists))  # x-coordinates for the bars

# Labels and Titles
labels = ["Country A Tourists", "Country B Tourists"]
title = "Seasonal Tourist Visits to Countries A and B"
xlabel = "Seasons"
ylabel1 = "Country A Tourists (in thousands)"
ylabel2 = "Country B Tourists (in thousands)"
legend_labels = ["Country A", "Country B"]
season_labels = ["Spring", "Summer", "Autumn", "Winter"]

# Plot configuration
ylim1 = [0, 200]  # y-axis limits for the first subplot
ylim2 = [0, 150]  # y-axis limits for the second subplot
yticks1 = [0, 50, 100, 150, 200]  # y-ticks for the first subplot
yticks2 = [0, 50, 100, 150]  # y-ticks for the second subplot

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size to match the original image's dimensions
fig, ax1 = plt.subplots(figsize=(8, 5))

# Colors
color_country_a = "#1f77b4"
color_country_b = "#ff7f0e"

# Create the first subplot for 'country_a_tourists' using the left y-axis
ax1.bar(
    x,
    country_a_tourists,
    width=0.4,
    label=legend_labels[0],
    color=color_country_a,
    align="center",
)
ax1.set_ylabel(ylabel1, color=color_country_a)
ax1.tick_params(axis="y", labelcolor=color_country_a)

# Create the second y-axis for 'country_b_tourists'
ax2 = ax1.twinx()
ax2.bar(
    x + 0.4,
    country_b_tourists,
    width=0.4,
    label=legend_labels[1],
    color=color_country_b,
    align="center",
)
ax2.set_ylabel(ylabel2, color=color_country_b)
ax2.tick_params(axis="y", labelcolor=color_country_b)

# Title and x-axis labels
ax1.set_title(title)
ax1.set_xlabel(xlabel)
ax1.set_xticks(x + 0.2)
ax1.set_xticklabels(season_labels)

# Drawing a horizontal line at y=0 (if needed)
# ax1.axhline(0, color="black", linewidth=0.8)

# Annotate bars with their values
for i in range(4):
    ax1.text(
        x[i],
        country_a_tourists[i] + 5,
        f"{country_a_tourists[i]}k",
        ha="center",
        color="black",
    )
    ax2.text(
        x[i] + 0.4,
        country_b_tourists[i] + 5,
        f"{country_b_tourists[i]}k",
        ha="center",
        color="black",
    )

ax1.set_ylim(ylim1)
ax1.set_yticks(yticks1)

ax2.set_ylim(ylim2)
ax2.set_yticks(yticks2)
ax2.set_yticklabels(yticks2)

# Add legends to the subplot
ax1.legend(loc="upper left", bbox_to_anchor=(0.0, 1.2))
ax1.grid(axis="y", linestyle="--")
ax1.set_axisbelow(True)
ax2.legend(loc="upper right", bbox_to_anchor=(1, 1.2))
ax2.grid(axis="y", linestyle="--")
ax2.set_axisbelow(True)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout
plt.tight_layout()
plt.savefig("bar_303.pdf", bbox_inches="tight")
