
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Generate some example environmental data
categories = ["Light Industry", "Heavy Industry", "Transportation", "Residential"]

# Simulated data: negative values for pollution emissions (in thousands of metric tons)
values1_A = [-np.random.uniform(400, 900) for _ in categories]  # Current Year
values2_A = [-np.random.uniform(500, 1000) for _ in categories]  # Previous Year

# Labels and titles
labels = ["Current Year", "Previous Year"]
xlabel = "Industry Sectors"
ylabel = "Pollution Emissions (thousands of metric tons)"
title = "Environmental Impact by Sector"
suptitle = "Comparative Analysis of Emissions Over Two Years"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set up the figure size
fig, ax = plt.subplots(figsize=(10, 6))

# New colors
current_year_color = "#4CAF50"  # Green for Current Year
previous_year_color = "#FF7043"  # Orange for Previous Year

# Make the bar plot with hatch patterns
ax.bar(
    categories,
    values1_A,
    color=current_year_color,
    hatch="/",
    label="Current Year",
    edgecolor="black",
)
ax.bar(
    categories,
    values2_A,
    color=previous_year_color,
    hatch="\\",
    label="Previous Year",
    bottom=values1_A,
    edgecolor="black",
)

# Labeling and customizing
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)
plt.suptitle(suptitle, y=1.05, fontsize=16)
plt.legend()

# Adding grid lines for better readability
plt.grid(axis="y", linestyle="--", alpha=0.7)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and display
plt.tight_layout()

# Save the plot as a PDF file
plt.savefig("bar_306.pdf", bbox_inches="tight")
