
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
age_groups = ["Children", "Teens", "Adults", "Middle-aged", "Elderly"]
sleep_hours = [10, 8.5, 7, 6.5, 6]
xlabel = "Age Group"
ylabel = "Average Hours of Sleep Per Night"
title = "Average Sleep Duration by Age Group"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(10, 6))
bar_colors = ["#76c7c0", "#80cbc4", "#82ada9", "#678d89", "#486d6c"]
plt.bar(age_groups, sleep_hours, color=bar_colors, edgecolor="black", linewidth=1.5)
plt.xlabel(xlabel, fontsize=12, fontweight='bold')
plt.ylabel(ylabel, fontsize=12, fontweight='bold')
plt.title(title, fontsize=14, fontweight='bold')
plt.grid(axis='y', linestyle='--', alpha=0.7)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("bar_309.pdf", bbox_inches="tight")
