
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
cities = ["Los Angeles", "New York", "Chicago", "Houston", "Phoenix"]
ticket_sales = [12500, 9800, 7400, 9200, 8600]
xlabel = "City"
ylabel = "Average Monthly Ticket Sales"
title = "Average Monthly Movie Ticket Sales by City"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(10, 5))
bars = plt.bar(cities, ticket_sales, color=["#FF6347", "#FFA500", "#8A2BE2", "#5F9EA0", "#FFD700"], 
               edgecolor="black", hatch="//")
plt.xlabel(xlabel, fontsize=12, fontweight='bold')
plt.ylabel(ylabel, fontsize=12, fontweight='bold')
plt.title(title, fontsize=14, fontweight='bold')
plt.grid(True, which='both', linestyle='--', linewidth=0.5, alpha=0.7)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("bar_310.pdf", bbox_inches="tight")
