
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
genres = ["Action", "Comedy", "Drama", "Horror", "Sci-Fi"]
box_office_revenue = [350.6, 200.4, 150.2, 75.8, 220.1]
xlabel = "Movie Genre"
ylabel = "Average Box Office Revenue (in million $)"
title = "Average Box Office Revenue by Movie Genre"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(10, 6))
colors = ["#FF6F61", "#6B5B95", "#88B04B", "#F7CAC9", "#92A8D1"]
bars = plt.bar(genres, box_office_revenue, color=colors, edgecolor="black")

# Stylize bars: Add rounded edges
for bar in bars:
    bar.set_linewidth(1.5)
    bar.set_linestyle('solid')
    bar.set_capstyle('round')

plt.xlabel(xlabel, fontsize=12)
plt.ylabel(ylabel, fontsize=12)
plt.title(title, fontsize=16, fontweight='bold')
plt.xticks(fontsize=10)
plt.yticks(fontsize=10)
plt.grid(axis='y', linestyle='--', alpha=0.7)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("bar_311.pdf", bbox_inches="tight")
