
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data points representing population in four regions
x = np.arange(4)  # X-axis points represent different regions
pop_2020 = np.array([100000, 120000, 110000, 130000])  # Population for 2020
pop_2021 = np.array([105000, 125000, 115000, 135000])  # Population for 2021
labels = ["2020 Population", "2021 Population"]
xticklabels = ["Region A", "Region B", "Region C", "Region D"]
title = "Population Growth by Region"
ylim1 = [0, 150000]
ylim2 = [0, 150000]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax1 = plt.subplots(figsize=(10, 5))
width = 0.4  # Width of the bars

# Plotting data for the year 2020
ax1.bar(
    x,
    pop_2020,
    color="#6a9fb5",
    hatch="x",
    width=width,
    label=labels[0],
    edgecolor="black"
)

# Create a second y-axis sharing the same x-axis
ax2 = ax1.twinx()
ax2.bar(
    x + width,
    pop_2021,
    color="#b5a6d9",
    hatch="o",
    width=width,
    label=labels[1],
    edgecolor="black"
)

# Set the x-ticks to be in the middle of the two bars and add labels for the regions
ax1.set_xticks(x + width / 2)
ax1.set_xticklabels(xticklabels)

# Adding legends to the plot
ax1.legend(loc="upper left")
ax2.legend(loc="upper right")

# Labeling y-axes
ax1.set_ylabel(labels[0], color="#417690")
ax2.set_ylabel(labels[1], color="#836bab")

# Setting colors for y-axis
ax1.tick_params(axis="y", colors="#417690")
ax2.tick_params(axis="y", colors="#836bab")

# Setting the limits for y-axes
ax1.set_ylim(ylim1)
ax2.set_ylim(ylim2)

# Title for the chart
plt.title(title)

# ===================
# Part 4: Saving Output
# ===================
# Layout adjustment to prevent clipping
plt.tight_layout()

# Saving the plot as a PDF
plt.savefig("bar_312.pdf", bbox_inches="tight")
