
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(0)
# Example data for energy sources
groups = ["Solar", "Wind", "Hydro", "Nuclear"]
efficiency_default = [20, 35, 30, 25]
efficiency_optimized = [25, 40, 35, 30]
carbon_default = [15, 10, 5, 20]
carbon_optimized = [10, 5, 2, 15]

n_groups = len(groups)

labels = ["Efficiency - Default", "Efficiency - Optimized", "Carbon - Default", "Carbon - Optimized"]
xlabel = "Energy Sources"
ylabel = "Score"
title = "Energy Source Efficiency and Carbon Emission Comparison"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the plot
fig, ax = plt.subplots(figsize=(10, 5))

index = np.arange(n_groups)
bar_width = 0.2

opacity = 0.8

# Bar plots with new color scheme
rects1 = ax.bar(
    index - 1.5 * bar_width,
    efficiency_default,
    bar_width,
    alpha=opacity,
    color="#93C572",  # Green for efficiency default
    label=labels[0],
)

rects2 = ax.bar(
    index - 0.5 * bar_width,
    efficiency_optimized,
    bar_width,
    alpha=opacity,
    color="#3A7CA5",  # Blue for efficiency optimized
    label=labels[1],
)

rects3 = ax.bar(
    index + 0.5 * bar_width,
    carbon_default,
    bar_width,
    alpha=opacity,
    color="#FFC300",  # Yellow for carbon default
    label=labels[2],
)

rects4 = ax.bar(
    index + 1.5 * bar_width,
    carbon_optimized,
    bar_width,
    alpha=opacity,
    color="#FF5733",  # Red for carbon optimized
    hatch="x",
    label=labels[3],
)

# Setting the chart details
ax.set_xlabel(xlabel, fontsize=12)
ax.set_ylabel(ylabel, fontsize=12)
ax.set_title(title, fontsize=14)
ax.set_xticks(index)
ax.set_xticklabels(groups)
ax.spines["top"].set_visible(False)
ax.spines["right"].set_visible(False)
ax.yaxis.grid(True, linestyle="--")
plt.legend()

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("bar_319.pdf", bbox_inches="tight")

