
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Example Data: Economic Indicators
years = ["2018", "2019", "2020", "2021"]
gdp_growth = [2.9, 2.3, -3.5, 6.4]      # GDP Growth Rate
unemployment_rate = [3.9, 3.6, 8.1, 6.0] # Unemployment Rate
inflation_rate = [2.4, 1.8, 1.2, 2.3]    # Inflation Rate
interest_rate = [2.4, 2.1, 0.5, 0.25]    # Interest Rate

n_years = len(years)

labels = ["GDP Growth Rate", "Unemployment Rate", "Inflation Rate", "Interest Rate"]
xlabel = "Year"
ylabel = "Percentage (%)"
title = "Key Economic Indicators Over Years"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the plot
fig, ax = plt.subplots(figsize=(10, 6))

index = np.arange(n_years)
bar_width = 0.2

opacity = 0.8

rects1 = ax.bar(
    index - 1.5 * bar_width,
    gdp_growth,
    bar_width,
    alpha=opacity,
    color="#1b9e77",
    label=labels[0],
)

rects2 = ax.bar(
    index - 0.5 * bar_width,
    unemployment_rate,
    bar_width,
    alpha=opacity,
    color="#d95f02",
    label=labels[1],
)

rects3 = ax.bar(
    index + 0.5 * bar_width,
    inflation_rate,
    bar_width,
    alpha=opacity,
    color="#7570b3",
    label=labels[2],
)

rects4 = ax.bar(
    index + 1.5 * bar_width,
    interest_rate,
    bar_width,
    alpha=opacity,
    color="#e7298a",
    hatch="///",
    label=labels[3],
)

ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)
ax.set_xticks(index)
ax.set_xticklabels(years)
ax.spines["top"].set_visible(False)
ax.spines["right"].set_visible(False)
ax.yaxis.grid(True, linestyle="--")

plt.legend()

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("bar_320.pdf", bbox_inches="tight")
