
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Data
N = 5
christianity = (0.6, 0.5, 0.4, 0.3)
islam = (0.2, 0.3, 0.3, 0.2)
hinduism = (0.1, 0.1, 0.2, 0.1)
buddhism = (0.05, 0.05, 0.05, 0.05)
judaism = (0.05, 0.05, 0.05, 0.05)

ind = np.arange(4)  # the x locations for the groups
width = 0.15  # the width of the bars

# Axes Limits and Labels
ylabel_value = "Belief Proportion"
xlabel_value = "Age Group"
title_value = "Religious Distribution Across Age Groups"
legend_labels = (
    "Christianity",
    "Islam",
    "Hinduism",
    "Buddhism",
    "Judaism",
)

# Adjust Area Limits and Labels
xlim_values = [-0.3, 3.7]
xticklabels = ("0-20", "21-40", "41-60", "61+")



# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig = plt.figure(figsize=(10, 6))  # Adjusting figure size as per the given dimensions
ax = fig.add_subplot(111)
# Colors
colors = (
    "#1f77b4",
    "#ff7f0e",
    "#2ca02c",
    "#d62728",
    "#9467bd",
)
rects1 = ax.bar(ind, christianity, width, color=colors[0])
rects2 = ax.bar(ind + width, islam, width, color=colors[1])
rects3 = ax.bar(ind + 2 * width, hinduism, width, color=colors[2])
rects4 = ax.bar(ind + 3 * width, buddhism, width, color=colors[3])
rects5 = ax.bar(ind + 4 * width, judaism, width, color=colors[4])

ax.set_ylabel(ylabel_value)
ax.set_xlabel(xlabel_value)
ax.set_xlim(xlim_values)
ax.set_xticks(ind + 2 * width)
ax.set_xticklabels(xticklabels)

ax.legend(
    (rects1[0], rects2[0], rects3[0], rects4[0], rects5[0]),
    legend_labels,
)

plt.title(title_value)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("bar_83.pdf", bbox_inches="tight")
