
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.patches as mpatches
import numpy as np

# ===================
# Part 2: Data Preparation
# ===================
# New domain data - Tech Products Benchmarking
datasets = ["Smartphones", "Laptops", "Tablets", "Smartwatches"]
models = ["w/o Feature A", "w/o Feature B", "w/o Feature C", "Full Model"]
Performance_data = {
    "Smartphones": [0.82, 0.84, 0.85, 0.90],
    "Laptops": [0.78, 0.80, 0.83, 0.87],
    "Tablets": [0.75, 0.77, 0.78, 0.85],
    "Smartwatches": [0.80, 0.82, 0.83, 0.86],
}
BatteryLife_data = {
    "Smartphones": [0.80, 0.85, 0.87, 0.89],
    "Laptops": [0.75, 0.78, 0.81, 0.84],
    "Tablets": [0.78, 0.80, 0.82, 0.85],
    "Smartwatches": [0.85, 0.87, 0.88, 0.90],
}
labels = ["Performance", "Battery Life"]
ylabel = "Metrics"
title = "Tech Products"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
lims = [(0.80, 0.92), (0.75, 0.89), (0.74, 0.88), (0.78, 0.92)]

# Create subplots
fig, axs = plt.subplots(1, 4, figsize=(12, 4))

# Updated color scheme
colors = ["#1f77b4", "#ff7f0e", "#2ca02c", "#d62728"]

# Plot each subplot
for i, dataset in enumerate(datasets):
    x = [3, 6]  # the label locations
    width = 0.5  # the width of the bars
    for j in range(len(Performance_data)):
        # Performance bars
        axs[i].bar(
            x[0] + (j - 1.5) * width,
            Performance_data[dataset][j],
            width,
            label=labels[0],
            color=colors[j],
            edgecolor="grey",
        )
        # Battery Life bars
        axs[i].bar(
            x[1] + (j - 1.5) * width,
            BatteryLife_data[dataset][j],
            width,
            label=labels[1],
            color=colors[j],
            edgecolor="grey",
        )

    # Add some text for labels, title, and custom x-axis tick labels, etc.
    axs[i].set_ylabel(ylabel)
    axs[i].set_ylim(lims[i][0], lims[i][1])
    axs[i].set_title(dataset)
    axs[i].set_xticks(x)
    axs[i].set_xticklabels(labels)

# Add legend
legend_handles = [
    mpatches.Patch(color=color, label=label) for color, label in zip(colors, models)
]
# Create legend
fig.legend(
    handles=legend_handles,
    loc="upper center",
    title=title,
    ncol=4,
    bbox_to_anchor=(0.5, 1.15),
)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("bar_88.pdf", bbox_inches="tight")

