
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np  # Import numpy in this section

np.random.seed(1)

# Data
labels = [
    "Bus",
    "Train",
    "Car",
    "Bicycle",
    "Walk",
    "Motorcycle",
    "Scooter",
    "Taxi",
    "Ferry",
    "Tram",
    "Plane",
    "Subway",
    "Helicopter",
    "Cable Car",
]
non_aggregation = [12.3, 8.5, 15.7, 0, 0, 10.2, 7.8, 14.3, 0, 0, 0, 0, 0, 0]
aggregation = [
    0,
    0,
    0,
    6.4,
    7.5,
    0,
    0,
    0,
    5.3,
    6.7,
    3.8,
    4.6,
    2.9,
    4.1,
]

line_y_1 = 6
line_y_2 = 10
line_x_1 = 4.5
line_x_2 = 10.5

# Labels and Plot Types
label_Non_Aggregation = "Motorized Transport"
label_Aggregation = "Non-Motorized Transport"
legend_title = "Transport Type"

# Axes Limits and Labels
ylabel_value = "Average Travel Time (mins)"
title_value = "Average Travel Time by Transport Type"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
x = np.arange(len(labels))  # the label locations
width = 0.7  # the width of the bars
ylim_values = [0, 18]
xlim_values = [-0.6, 14]

# Color Scheme
color_non_aggregation = "#2E8B57"  # SeaGreen
color_aggregation = "#FF6347"      # Tomato

# Plotting
fig, ax = plt.subplots(
    figsize=(12, 6)
)  # Adjust the size to match the original image's dimensions
rects1 = ax.bar(x, non_aggregation, width, label=label_Non_Aggregation, color=color_non_aggregation)
rects2 = ax.bar(x, aggregation, width, label=label_Aggregation, color=color_aggregation)

# Add some text for labels, title and custom x-axis tick labels, etc.
ax.set_ylabel(ylabel_value)
ax.set_title(title_value)
ax.set_xticks(x)
ax.set_xticklabels(labels, rotation=45, ha="center")
ax.set_ylim(ylim_values)
ax.set_xlim(xlim_values)

# Adding the values on top of the bars
for rect in rects1:
    if rect.get_height() > 0:
        height = rect.get_height()
        ax.annotate(
            "{}".format(height),
            xy=(rect.get_x() + rect.get_width() / 2, height),
            xytext=(0, 3),  # 3 points vertical offset
            textcoords="offset points",
            ha="center",
            va="bottom",
        )
for rect in rects2:
    if rect.get_height() > 0:
        height = rect.get_height()
        ax.annotate(
            "{}".format(height),
            xy=(rect.get_x() + rect.get_width() / 2, height),
            xytext=(0, 3),  # 3 points vertical offset
            textcoords="offset points",
            ha="center",
            va="bottom",
        )

# Reference lines
ax.axhline(y=line_y_1, color="red", linestyle="--")
ax.axhline(y=line_y_2, color="blue", linestyle="--")
ax.axvline(x=line_x_1, color="gray", linestyle="--")
ax.axvline(x=line_x_2, color="gray", linestyle="--")

# Hide the ticks
ax.tick_params(axis="both", which="both", length=0)

# Hide the right and top spines
ax.spines["right"].set_visible(False)
ax.spines["top"].set_visible(False)
ax.legend(title=legend_title)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("bar_92.pdf", bbox_inches="tight")
