
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data for the bar chart
months = ["June", "July", "August"]
city_a_rainfall = [120, 150, 180]
city_b_rainfall = [130, 160, 170]
city_c_rainfall = [110, 140, 160]

labels = ["City A", "City B", "City C"]
ylabel = "Avg. Rainfall (mm)"

y_index = [0, 50, 100, 150, 200]
ylim = [0, 200]
y_label_ticks = ["0", "50", "100", "150", "200"]

# Annotations for bar heights
annotation_offsets = 5  # Offset for text annotations above bars

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size to match the original image's dimensions
plt.figure(figsize=(8, 4))

# Create the bar chart
bar_width = 0.25
index = range(len(months))

colors = ["#6baed6", "#9ecae1", "#c6dbef"]  # Shades of blue for rainfall

plt.bar(
    [i - bar_width for i in index],
    city_a_rainfall,
    width=bar_width,
    color=colors[0],
    edgecolor="black",
    label=labels[0],
)
plt.bar(
    index, city_b_rainfall, width=bar_width, color=colors[1], edgecolor="black", label=labels[1]
)
plt.bar(
    [i + bar_width for i in index],
    city_c_rainfall,
    width=bar_width,
    color=colors[2],
    edgecolor="black",
    label=labels[2],
)

# Add the text labels on top of the bars
for i in index:
    plt.text(
        i - bar_width,
        city_a_rainfall[i] + annotation_offsets,
        f"{city_a_rainfall[i]}",
        ha="center",
    )
    plt.text(i, city_b_rainfall[i] + annotation_offsets, f"{city_b_rainfall[i]}", ha="center")
    plt.text(i + bar_width, city_c_rainfall[i] + annotation_offsets, f"{city_c_rainfall[i]}", ha="center")

# Set the x-axis labels, y-axis label, and chart title
plt.xticks(index, months)
plt.ylabel(ylabel)
plt.ylim(ylim)
plt.yticks(y_index, y_label_ticks)

# Add a legend
plt.legend(loc="upper center", bbox_to_anchor=(0.5, 1.15), ncol=3)

# Hide the right and top spines
plt.gca().spines["right"].set_visible(False)
plt.gca().spines["top"].set_visible(False)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("bar_93.pdf", bbox_inches="tight")
